/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.codec.protobuf;

import com.google.protobuf.Message;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.support.Assert;
import reactor.fn.Consumer;
import reactor.fn.Function;
import reactor.io.codec.SerializationCodec;

public class ProtobufCodec<IN, OUT>
extends SerializationCodec<Map<Class<?>, Message>, IN, OUT> {
    public ProtobufCodec() {
        this(true);
    }

    public ProtobufCodec(boolean lengthFieldFraming) {
        super(new ConcurrentHashMap(), lengthFieldFraming);
    }

    @Override
    protected Function<byte[], IN> deserializer(final Map<Class<?>, Message> messages, final Class<IN> type, final Consumer<IN> next) {
        Assert.isAssignable(Message.class, type, "Can only deserialize Protobuf messages. " + type.getName() + " is not an instance of " + Message.class.getName());
        return new Function<byte[], IN>(){

            @Override
            public IN apply(byte[] bytes) {
                try {
                    Message msg = (Message)messages.get(type);
                    if (null == msg) {
                        msg = (Message)type.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
                        messages.put(type, msg);
                    }
                    Message obj = msg.newBuilderForType().mergeFrom(bytes).build();
                    if (null != next) {
                        next.accept(obj);
                        return null;
                    }
                    return obj;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        };
    }

    @Override
    protected Function<OUT, byte[]> serializer(Map<Class<?>, Message> messages) {
        return new Function<OUT, byte[]>(){

            @Override
            public byte[] apply(Object o) {
                Assert.isInstanceOf(Message.class, o, "Can only serialize Protobuf messages. " + o.getClass().getName() + " is not an instance of " + Message.class.getName());
                return ((Message)o).toByteArray();
            }
        };
    }
}

