/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.command.closure.AsyncClosureFactory;
import com.netflix.hystrix.contrib.javanica.command.closure.Closure;
import com.netflix.hystrix.contrib.javanica.exception.CommandActionExecutionException;
import com.netflix.hystrix.contrib.javanica.exception.ExceptionUtils;
import com.netflix.hystrix.contrib.javanica.utils.EnvUtils;
import com.netflix.hystrix.contrib.javanica.utils.ajc.AjcUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodExecutionAction
implements CommandAction {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final Object object;
    private final Method method;
    private final Object[] _args;
    private final MetaHolder metaHolder;

    public MethodExecutionAction(Object object, Method method, MetaHolder metaHolder) {
        this.object = object;
        this.method = method;
        this._args = EMPTY_ARGS;
        this.metaHolder = metaHolder;
    }

    public MethodExecutionAction(Object object, Method method, Object[] args, MetaHolder metaHolder) {
        this.object = object;
        this.method = method;
        this._args = args;
        this.metaHolder = metaHolder;
    }

    public Object getObject() {
        return this.object;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArgs() {
        return this._args;
    }

    @Override
    public MetaHolder getMetaHolder() {
        return this.metaHolder;
    }

    @Override
    public Object execute(ExecutionType executionType) throws CommandActionExecutionException {
        return this.executeWithArgs(executionType, this._args);
    }

    @Override
    public Object executeWithArgs(ExecutionType executionType, Object[] args) throws CommandActionExecutionException {
        if (ExecutionType.ASYNCHRONOUS == executionType) {
            Closure closure = AsyncClosureFactory.getInstance().createClosure(this.metaHolder, this.method, this.object, args);
            return this.executeClj(closure.getClosureObj(), closure.getClosureMethod(), new Object[0]);
        }
        return this.execute(this.object, this.method, args);
    }

    @Override
    public String getActionName() {
        return this.method.getName();
    }

    private Object execute(Object o, Method m, Object ... args) throws CommandActionExecutionException {
        Object result = null;
        try {
            m.setAccessible(true);
            result = EnvUtils.isCompileWeaving() && this.metaHolder.getAjcMethod() != null ? AjcUtils.invokeAjcMethod(this.metaHolder.getAjcMethod(), o, this.metaHolder, args) : m.invoke(o, args);
        }
        catch (IllegalAccessException e) {
            this.propagateCause(e);
        }
        catch (InvocationTargetException e) {
            this.propagateCause(e);
        }
        return result;
    }

    private Object executeClj(Object o, Method m, Object ... args) {
        Object result = null;
        try {
            m.setAccessible(true);
            result = m.invoke(o, args);
        }
        catch (IllegalAccessException e) {
            this.propagateCause(e);
        }
        catch (InvocationTargetException e) {
            this.propagateCause(e);
        }
        return result;
    }

    private void propagateCause(Throwable throwable) throws CommandActionExecutionException {
        ExceptionUtils.propagateCause(throwable);
    }
}

