/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.groovy;

import com.netflix.zuul.DynamicCodeCompiler;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyCompiler
implements DynamicCodeCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(GroovyCompiler.class);

    @Override
    public Class compile(String sCode, String sName) {
        GroovyClassLoader loader = this.getGroovyClassLoader();
        LOG.warn("Compiling filter: " + sName);
        Class groovyClass = loader.parseClass(sCode, sName);
        return groovyClass;
    }

    GroovyClassLoader getGroovyClassLoader() {
        return new GroovyClassLoader();
    }

    @Override
    public Class compile(File file) throws IOException {
        GroovyClassLoader loader = this.getGroovyClassLoader();
        Class groovyClass = loader.parseClass(file);
        return groovyClass;
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        @Test
        public void testLoadGroovyFromString() {
            GroovyCompiler compiler = (GroovyCompiler)Mockito.spy((Object)new GroovyCompiler());
            try {
                String code = "class test { public String hello(){return \"hello\" } } ";
                Class clazz = compiler.compile(code, "test");
                Assert.assertNotNull((Object)clazz);
                Assert.assertEquals((Object)clazz.getName(), (Object)"test");
                GroovyObject groovyObject = (GroovyObject)clazz.newInstance();
                Object[] args = new Object[]{};
                String s = (String)groovyObject.invokeMethod("hello", (Object)args);
                Assert.assertEquals((Object)s, (Object)"hello");
            }
            catch (Exception e) {
                Assert.assertFalse((boolean)true);
            }
        }
    }
}

