/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.cloud.netflix.zuul.filters.RefreshableRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.Assert;

public class CompositeRouteLocator
implements RefreshableRouteLocator {
    private final Collection<? extends RouteLocator> routeLocators;
    private ArrayList<RouteLocator> rl;

    public CompositeRouteLocator(Collection<? extends RouteLocator> routeLocators) {
        Assert.notNull(routeLocators, (String)"'routeLocators' must not be null");
        this.rl = new ArrayList<RouteLocator>(routeLocators);
        AnnotationAwareOrderComparator.sort(this.rl);
        this.routeLocators = this.rl;
    }

    @Override
    public Collection<String> getIgnoredPaths() {
        ArrayList<String> ignoredPaths = new ArrayList<String>();
        for (RouteLocator routeLocator : this.routeLocators) {
            ignoredPaths.addAll(routeLocator.getIgnoredPaths());
        }
        return ignoredPaths;
    }

    @Override
    public List<Route> getRoutes() {
        ArrayList<Route> route = new ArrayList<Route>();
        for (RouteLocator routeLocator : this.routeLocators) {
            route.addAll(routeLocator.getRoutes());
        }
        return route;
    }

    @Override
    public Route getMatchingRoute(String path) {
        for (RouteLocator routeLocator : this.routeLocators) {
            Route route = routeLocator.getMatchingRoute(path);
            if (route == null) continue;
            return route;
        }
        return null;
    }

    @Override
    public void refresh() {
        for (RouteLocator routeLocator : this.routeLocators) {
            if (!(routeLocator instanceof RefreshableRouteLocator)) continue;
            ((RefreshableRouteLocator)routeLocator).refresh();
        }
    }
}

