/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.metrics;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultClientEndpointMetric;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultClientEndpointMetricManager;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultEndpointMetric;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultTcpSocketMetric;

public class DefaultTcpClientMetrics
implements TCPMetrics<DefaultTcpSocketMetric> {
    private final DefaultClientEndpointMetricManager clientEndpointMetricManager;

    public DefaultTcpClientMetrics(DefaultClientEndpointMetricManager clientEndpointMetricManager) {
        this.clientEndpointMetricManager = clientEndpointMetricManager;
    }

    public DefaultTcpSocketMetric connected(SocketAddress remoteAddress, String remoteName) {
        DefaultClientEndpointMetric endpointMetric = this.clientEndpointMetricManager.getOrCreateEndpointMetric(remoteAddress.toString());
        endpointMetric.onConnect();
        return new DefaultTcpSocketMetric(endpointMetric);
    }

    public void disconnected(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress) {
        socketMetric.onDisconnect();
    }

    public void bytesRead(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        ((DefaultEndpointMetric)socketMetric.getEndpointMetric()).addBytesRead(numberOfBytes);
    }

    public void bytesWritten(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        ((DefaultEndpointMetric)socketMetric.getEndpointMetric()).addBytesWritten(numberOfBytes);
    }

    public void exceptionOccurred(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress, Throwable t) {
    }

    @Deprecated
    public boolean isEnabled() {
        return true;
    }

    public void close() {
    }
}

