/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.CharSetter;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class StringReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (Character.TYPE.equals(javaType.getRawClass())) {
            return new CharFieldStringSchema(protoField, propertyDescriptor);
        }
        if (String.class.equals((Object)javaType.getRawClass()) || javaType.isJavaLangObject() || Character.class.equals((Object)javaType.getRawClass())) {
            return new StringSchema(protoField, propertyDescriptor);
        }
        ProtoUtils.throwNotSupportMerge(protoField, propertyDescriptor.getJavaType());
        return null;
    }

    private static class CharFieldStringSchema<T>
    extends FieldSchema<T> {
        private final CharSetter<T> setter;

        public CharFieldStringSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (CharSetter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            String value = input.readString();
            this.setter.set(message, value.toCharArray()[0]);
            return input.readFieldNumber();
        }
    }

    private static class StringSchema<T>
    extends FieldSchema<T> {
        private final Setter<T, Object> setter;

        public StringSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (Setter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            String value = input.readString();
            if (Character.TYPE.equals(this.javaType.getRawClass()) || Character.class.equals((Object)this.javaType.getRawClass())) {
                this.setter.set(message, (Object)Character.valueOf(value.toCharArray()[0]));
            } else {
                this.setter.set(message, (Object)value);
            }
            return input.readFieldNumber();
        }
    }
}

