/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.zeroconfig;

import java.time.Duration;
import org.apache.servicecomb.config.DynamicProperties;
import org.springframework.beans.factory.annotation.Autowired;

public class Config {
    private DynamicProperties dynamicProperties;

    @Autowired
    public Config setDynamicProperties(DynamicProperties dynamicProperties) {
        this.dynamicProperties = dynamicProperties;
        return this;
    }

    public boolean isEnabled() {
        return this.dynamicProperties.getBooleanProperty("servicecomb.registry.zero-config.enabled", true);
    }

    public String getMulticastAddress() {
        return this.dynamicProperties.getStringProperty("servicecomb.registry.zero-config.multicast.address", "0.0.0.0:6666");
    }

    public String getMulticastGroup() {
        return this.dynamicProperties.getStringProperty("servicecomb.registry.zero-config.multicast.group", "225.6.7.8");
    }

    public Duration getHeartbeatInterval() {
        String interval = this.dynamicProperties.getStringProperty("servicecomb.registry.zero-config.heartbeat.interval", "30s");
        return this.toDuration(interval);
    }

    public Duration getCheckDeadInstancesInterval() {
        int lostTimes = this.dynamicProperties.getIntProperty("servicecomb.registry.zero-config.heartbeat.lost-times", 3);
        return this.getHeartbeatInterval().multipliedBy(lostTimes);
    }

    public Duration getPullInterval() {
        String interval = this.dynamicProperties.getStringProperty("servicecomb.registry.zero-config.pull-interval", "3s");
        return this.toDuration(interval);
    }

    private Duration toDuration(String interval) {
        return Duration.parse("PT" + interval);
    }
}

