/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.engine.unittest;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.swagger.engine.SwaggerConsumer;
import org.apache.servicecomb.swagger.engine.SwaggerConsumerOperation;
import org.apache.servicecomb.swagger.engine.SwaggerProducer;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;

public class LocalProducerInvoker
implements InvocationHandler {
    private Object proxy;
    private SwaggerConsumer consumer;
    private SwaggerProducer producer;
    private SwaggerInvocation invocation;
    private Response producerResponse;

    public LocalProducerInvoker(SwaggerConsumer consumer, SwaggerProducer producer) {
        this.consumer = consumer;
        this.producer = producer;
        this.proxy = Proxy.newProxyInstance(consumer.getConsumerIntf().getClassLoader(), new Class[]{consumer.getConsumerIntf()}, (InvocationHandler)this);
    }

    public <T> T getProxy() {
        return (T)this.proxy;
    }

    public SwaggerInvocation getInvocation() {
        return this.invocation;
    }

    public <T> T getSwaggerArgument(int idx) {
        return this.invocation.getSwaggerArgument(idx);
    }

    public String getContext(String key) {
        return this.invocation.getContext(key);
    }

    public Response getProducerResponse() {
        return this.producerResponse;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.invocation = new SwaggerInvocation();
        SwaggerConsumerOperation consumerOp = this.consumer.findOperation(method.getName());
        SwaggerProducerOperation producerOp = this.producer.findOperation(consumerOp.getSwaggerMethod().getName());
        consumerOp.getArgumentsMapper().toInvocation(args, this.invocation);
        CompletableFuture future = new CompletableFuture();
        producerOp.invoke(this.invocation, ar -> {
            this.producerResponse = ar;
            Object realResult = consumerOp.getResponseMapper().mapResponse(this.producerResponse);
            future.complete(realResult);
        });
        if (CompletableFuture.class.equals(method.getReturnType())) {
            return future;
        }
        return future.get();
    }
}

