/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.validator.tag;

import io.swagger.v3.oas.models.tags.Tag;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.util.StringCaseUtils;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.TagValidator;

public class TagNameCaseValidator
implements TagValidator {
    public static final String CONFIG_KEY = "tag.name.case";
    public static final String ERROR = "Must be ";
    private final String expectedCase;

    public TagNameCaseValidator(String expectedCase) {
        this.expectedCase = expectedCase;
    }

    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, Tag tag) {
        if (!StringCaseUtils.isMatchCase((String)this.expectedCase, (String)tag.getName())) {
            return Collections.singletonList(new OasViolation(location.property("name"), ERROR + this.expectedCase));
        }
        return Collections.emptyList();
    }
}

