/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.ArrayModel;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.Xml;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Yaml;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RustServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RustServerCodegen.class);
    private HashMap<String, String> modelXmlNames = new HashMap();
    private static final String NO_FORMAT = "%%NO_FORMAT";
    protected String apiVersion = "1.0.0";
    protected String serverHost = "localhost";
    protected int serverPort = 8080;
    protected String projectName = "swagger-server";
    protected String apiPath = "rust-server";
    protected String packageName;
    protected String packageVersion;
    protected String externCrateName;
    protected Map<String, Map<String, String>> pathSetMap = new HashMap<String, Map<String, String>>();

    public RustServerCodegen() {
        this.outputFolder = "generated-code/rust-server";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.clear();
        this.templateDir = "rust-server";
        this.embeddedTemplateDir = "rust-server";
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "alignof", "as", "become", "box", "break", "const", "continue", "crate", "do", "else", "enum", "extern", "false", "final", "fn", "for", "if", "impl", "in", "let", "loop", "macro", "match", "mod", "move", "mut", "offsetof", "override", "priv", "proc", "pub", "pure", "ref", "return", "Self", "self", "sizeof", "static", "struct", "super", "trait", "true", "type", "typeof", "unsafe", "unsized", "use", "virtual", "where", "while", "yield"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "char", "i8", "i16", "i32", "i64", "u8", "u16", "u32", "u64", "isize", "usize", "f32", "f64", "str"));
        this.instantiationTypes.clear();
        this.instantiationTypes.put("array", "Vec");
        this.instantiationTypes.put("map", "Map");
        this.typeMapping.clear();
        this.typeMapping.put("number", "f64");
        this.typeMapping.put("integer", "i32");
        this.typeMapping.put("long", "i64");
        this.typeMapping.put("float", "f32");
        this.typeMapping.put("double", "f64");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("UUID", "uuid::Uuid");
        this.typeMapping.put("byte", "u8");
        this.typeMapping.put("ByteArray", "swagger::ByteArray");
        this.typeMapping.put("binary", "swagger::ByteArray");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("date", "chrono::DateTime<chrono::Utc>");
        this.typeMapping.put("DateTime", "chrono::DateTime<chrono::Utc>");
        this.typeMapping.put("password", "String");
        this.typeMapping.put("File", "Box<Stream<Item=Vec<u8>, Error=Error> + Send>");
        this.typeMapping.put("file", "Box<Stream<Item=Vec<u8>, Error=Error> + Send>");
        this.typeMapping.put("array", "Vec");
        this.typeMapping.put("map", "HashMap");
        this.importMapping = new HashMap();
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Rust crate name (convention: snake_case).").defaultValue("swagger_client"));
        this.cliOptions.add(new CliOption("packageVersion", "Rust crate version.").defaultValue("1.0.0"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("apiPath", this.apiPath);
        this.supportingFiles.add(new SupportingFile("swagger.mustache", "api", "swagger.yaml"));
        this.supportingFiles.add(new SupportingFile("Cargo.mustache", "", "Cargo.toml"));
        this.supportingFiles.add(new SupportingFile("cargo-config", ".cargo", "config"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("lib.mustache", "src", "lib.rs"));
        this.supportingFiles.add(new SupportingFile("models.mustache", "src", "models.rs"));
        this.supportingFiles.add(new SupportingFile("server-mod.mustache", "src/server", "mod.rs"));
        this.supportingFiles.add(new SupportingFile("server-auth.mustache", "src/server", "auth.rs"));
        this.supportingFiles.add(new SupportingFile("client-mod.mustache", "src/client", "mod.rs"));
        this.supportingFiles.add(new SupportingFile("mimetypes.mustache", "src", "mimetypes.rs"));
        this.supportingFiles.add(new SupportingFile("example-server.mustache", "examples", "server.rs"));
        this.supportingFiles.add(new SupportingFile("example-client.mustache", "examples", "client.rs"));
        this.supportingFiles.add(new SupportingFile("example-server_lib.mustache", "examples/server_lib", "mod.rs"));
        this.supportingFiles.add(new SupportingFile("example-server_server.mustache", "examples/server_lib", "server.rs"));
        this.supportingFiles.add(new SupportingFile("example-ca.pem", "examples", "ca.pem"));
        this.supportingFiles.add(new SupportingFile("example-server-chain.pem", "examples", "server-chain.pem"));
        this.supportingFiles.add(new SupportingFile("example-server-key.pem", "examples", "server-key.pem"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("swagger_client");
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.additionalProperties.put("externCrateName", this.externCrateName);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        this.externCrateName = packageName.replace('-', '_');
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    @Override
    public String apiPackage() {
        return this.apiPath;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "rust-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Rust client/server library (beta) using the swagger-codegen project.";
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        Info info = swagger.getInfo();
        ArrayList<String> versionComponents = new ArrayList<String>(Arrays.asList(info.getVersion().split("[.]")));
        if (versionComponents.size() < 1) {
            versionComponents.add("1");
        }
        while (versionComponents.size() < 3) {
            versionComponents.add("0");
        }
        info.setVersion(StringUtils.join(versionComponents, (String)"."));
        String host = swagger.getHost();
        if (host != null) {
            String[] parts = host.split(":");
            if (parts.length > 1) {
                this.serverHost = parts[0];
                try {
                    this.serverPort = Integer.valueOf(parts[1]);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Port of Swagger host is not an integer : " + host, (Throwable)e);
                }
            } else {
                this.serverHost = host;
            }
        }
        this.additionalProperties.put("serverHost", this.serverHost);
        this.additionalProperties.put("serverPort", this.serverPort);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "default";
        }
        return RustServerCodegen.underscore(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toModelName(String name) {
        String camelizedName = RustServerCodegen.camelize(this.toModelFilename(name));
        if (this.isReservedWord(camelizedName)) {
            camelizedName = "Model" + camelizedName;
            LOGGER.warn(camelizedName + " (reserved word) cannot be used as model name. Renamed to " + camelizedName);
        } else if (name.matches("^\\d.*")) {
            camelizedName = "Model" + camelizedName;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + camelizedName);
        }
        return camelizedName;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toVarName(String name) {
        String sanitizedName = super.sanitizeName(name);
        if (this.isReservedWord(sanitizedName) || sanitizedName.matches("^\\d.*")) {
            sanitizedName = this.escapeReservedWord(sanitizedName);
        }
        return RustServerCodegen.underscore(sanitizedName);
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + RustServerCodegen.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return RustServerCodegen.camelize(operationId);
    }

    @Override
    public String toModelFilename(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + RustServerCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return RustServerCodegen.underscore(name);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(RustServerCodegen.camelize(property.name)) + "Enum";
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        String var = null;
        if (value.length() == 0) {
            var = "EMPTY";
        } else if (this.getSymbolName(value) != null) {
            var = this.getSymbolName(value).toUpperCase();
        } else if ("Integer".equals(datatype) || "Long".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            String varName = "NUMBER_" + value;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            var = varName = varName.replaceAll("\\.", "_DOT_");
        }
        var = value.replaceAll("\\W+", "_").toUpperCase();
        var = var.matches("\\d.*") ? "_" + var : this.sanitizeName(var);
        return var;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Long".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return RustServerCodegen.underscore(name);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    boolean isMimetypeXml(String mimetype) {
        return mimetype.toLowerCase().startsWith("application/xml");
    }

    boolean isMimetypePlainText(String mimetype) {
        return mimetype.toLowerCase().startsWith("text/plain");
    }

    boolean isMimetypeWwwFormUrlEncoded(String mimetype) {
        return mimetype.toLowerCase().startsWith("application/x-www-form-urlencoded");
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        Map<String, String> pathSetEntry;
        String basePathId;
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, definitions, swagger);
        String pathId = basePathId = this.sanitizeName(op.path.replace("/", "_").replace("{", "").replace("}", "").replaceAll("^_", "")).toUpperCase();
        int pathIdTiebreaker = 2;
        boolean found = false;
        while (this.pathSetMap.containsKey(pathId)) {
            pathSetEntry = this.pathSetMap.get(pathId);
            if (pathSetEntry.get("path").equals(op.path)) {
                found = true;
                break;
            }
            pathId = basePathId + pathIdTiebreaker;
            ++pathIdTiebreaker;
        }
        if (!found) {
            pathSetEntry = new HashMap<String, String>();
            pathSetEntry.put("path", op.path);
            pathSetEntry.put("PATH_ID", pathId);
            if (!op.pathParams.isEmpty()) {
                pathSetEntry.put("hasPathParams", "true");
            }
            pathSetEntry.put("pathRegEx", op.path.replace("{", "(?P<").replace("}", ">[^/?#]*)") + "$");
            this.pathSetMap.put(pathId, pathSetEntry);
        }
        op.vendorExtensions.put("operation_id", RustServerCodegen.underscore(op.operationId));
        op.vendorExtensions.put("uppercase_operation_id", RustServerCodegen.underscore(op.operationId).toUpperCase());
        op.vendorExtensions.put("path", op.path.replace("{", ":").replace("}", ""));
        op.vendorExtensions.put("PATH_ID", pathId);
        op.vendorExtensions.put("hasPathParams", !op.pathParams.isEmpty());
        op.vendorExtensions.put("HttpMethod", Character.toUpperCase(op.httpMethod.charAt(0)) + op.httpMethod.substring(1).toLowerCase());
        for (CodegenParameter param : op.allParams) {
            this.processParam(param, op);
        }
        List consumes = new ArrayList();
        if (operation.getConsumes() != null) {
            if (operation.getConsumes().size() > 0) {
                consumes = operation.getConsumes();
            }
        } else if (swagger != null && swagger.getConsumes() != null && swagger.getConsumes().size() > 0) {
            consumes = swagger.getConsumes();
            LOGGER.debug("No consumes defined in operation. Using global consumes (" + swagger.getConsumes() + ") for " + op.operationId);
        }
        boolean consumesPlainText = false;
        boolean consumesXml = false;
        if (consumes != null && !consumes.isEmpty()) {
            ArrayList<Map<String, String>> c = new ArrayList<Map<String, String>>();
            for (String mimeType : consumes) {
                HashMap<String, String> mediaType = new HashMap<String, String>();
                if (this.isMimetypeXml(mimeType)) {
                    this.additionalProperties.put("usesXml", true);
                    consumesXml = true;
                } else if (this.isMimetypePlainText(mimeType)) {
                    consumesPlainText = true;
                } else if (this.isMimetypeWwwFormUrlEncoded(mimeType)) {
                    this.additionalProperties.put("usesUrlEncodedForm", true);
                }
                mediaType.put("mediaType", mimeType);
                c.add(mediaType);
            }
            op.consumes = c;
            op.hasConsumes = true;
        }
        List produces = new ArrayList();
        if (operation.getProduces() != null) {
            if (operation.getProduces().size() > 0) {
                produces = operation.getProduces();
            }
        } else if (swagger != null && swagger.getProduces() != null && swagger.getProduces().size() > 0) {
            produces = swagger.getProduces();
            LOGGER.debug("No produces defined in operation. Using global produces (" + swagger.getProduces() + ") for " + op.operationId);
        }
        boolean producesXml = false;
        boolean producesPlainText = false;
        if (produces != null && !produces.isEmpty()) {
            ArrayList<Map<String, String>> c = new ArrayList<Map<String, String>>();
            for (String mimeType : produces) {
                HashMap<String, String> mediaType = new HashMap<String, String>();
                if (this.isMimetypeXml(mimeType)) {
                    this.additionalProperties.put("usesXml", true);
                    producesXml = true;
                } else if (this.isMimetypePlainText(mimeType)) {
                    producesPlainText = true;
                }
                mediaType.put("mediaType", mimeType);
                c.add(mediaType);
            }
            op.produces = c;
            op.hasProduces = true;
        }
        if (op.bodyParam != null) {
            if (this.paramHasXmlNamespace(op.bodyParam, definitions)) {
                op.bodyParam.vendorExtensions.put("has_namespace", "true");
            }
            for (String key : definitions.keySet()) {
                op.bodyParam.vendorExtensions.put("model_key", key);
            }
            op.bodyParam.vendorExtensions.put("uppercase_operation_id", RustServerCodegen.underscore(op.operationId).toUpperCase());
            if (consumesXml) {
                op.bodyParam.vendorExtensions.put("consumesXml", true);
            } else if (consumesPlainText) {
                op.bodyParam.vendorExtensions.put("consumesPlainText", true);
            } else {
                op.bodyParam.vendorExtensions.put("consumesJson", true);
            }
        }
        for (CodegenParameter param : op.bodyParams) {
            this.processParam(param, op);
            if (this.paramHasXmlNamespace(param, definitions)) {
                param.vendorExtensions.put("has_namespace", "true");
            }
            param.vendorExtensions.put("uppercase_operation_id", RustServerCodegen.underscore(op.operationId).toUpperCase());
            if (consumesXml) {
                param.vendorExtensions.put("consumesXml", true);
                continue;
            }
            if (consumesPlainText) {
                param.vendorExtensions.put("consumesPlainText", true);
                continue;
            }
            param.vendorExtensions.put("consumesJson", true);
        }
        for (CodegenParameter param : op.headerParams) {
            if (param.dataType.equals("uuid::Uuid")) {
                this.additionalProperties.put("apiUsesUuid", true);
            }
            this.processParam(param, op);
            param.vendorExtensions.put("typeName", this.toModelName(param.baseName));
        }
        for (CodegenParameter param : op.formParams) {
            this.processParam(param, op);
        }
        for (CodegenResponse rsp : op.responses) {
            String[] words = rsp.message.split("[^A-Za-z ]");
            String responseId = rsp.vendorExtensions.containsKey("x-responseId") ? (String)rsp.vendorExtensions.get("x-responseId") : (words.length != 0 ? RustServerCodegen.camelize(words[0].replace(" ", "_")) : "Status" + rsp.code);
            rsp.vendorExtensions.put("x-responseId", responseId);
            rsp.vendorExtensions.put("x-uppercaseResponseId", RustServerCodegen.underscore(responseId).toUpperCase());
            rsp.vendorExtensions.put("uppercase_operation_id", RustServerCodegen.underscore(op.operationId).toUpperCase());
            if (rsp.dataType != null) {
                rsp.vendorExtensions.put("uppercase_data_type", rsp.dataType.replace("models::", "").toUpperCase());
                if (producesXml) {
                    rsp.vendorExtensions.put("producesXml", true);
                } else if (producesPlainText) {
                    rsp.vendorExtensions.put("producesPlainText", true);
                } else {
                    rsp.vendorExtensions.put("producesJson", true);
                }
                Object property = rsp.schema;
                if (property != null && property instanceof RefProperty) {
                    Xml xml;
                    Model model;
                    RefProperty refProperty = (RefProperty)property;
                    String refName = refProperty.get$ref();
                    if (refName.indexOf("#/definitions/") == 0) {
                        refName = refName.substring("#/definitions/".length());
                    }
                    if ((model = definitions.get(refName)) != null && model instanceof ModelImpl && (xml = ((ModelImpl)model).getXml()) != null && xml.getNamespace() != null) {
                        rsp.vendorExtensions.put("has_namespace", "true");
                    }
                }
            }
            for (CodegenProperty header : rsp.headers) {
                if (header.datatype.equals("uuid::Uuid")) {
                    this.additionalProperties.put("apiUsesUuid", true);
                }
                header.nameInCamelCase = this.toModelName(header.baseName);
            }
        }
        for (CodegenProperty header : op.responseHeaders) {
            if (header.datatype.equals("uuid::Uuid")) {
                this.additionalProperties.put("apiUsesUuid", true);
            }
            header.nameInCamelCase = this.toModelName(header.baseName);
        }
        return op;
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return dataType != null && dataType.equals(((String)this.typeMapping.get("File")).toString());
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            String innerType = this.getTypeDeclaration(inner);
            StringBuilder typeDeclaration = new StringBuilder((String)this.typeMapping.get("array")).append("<");
            if (inner instanceof RefProperty) {
                typeDeclaration.append("models::");
            }
            typeDeclaration.append(innerType).append(">");
            return typeDeclaration.toString();
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            String innerType = this.getTypeDeclaration(inner);
            StringBuilder typeDeclaration = new StringBuilder((String)this.typeMapping.get("map")).append("<").append((String)this.typeMapping.get("string")).append(", ");
            if (inner instanceof RefProperty) {
                typeDeclaration.append("models::");
            }
            typeDeclaration.append(innerType).append(">");
            return typeDeclaration.toString();
        }
        if (p instanceof RefProperty) {
            String datatype;
            try {
                RefProperty r = (RefProperty)p;
                datatype = r.get$ref();
                if (datatype.indexOf("#/definitions/") == 0) {
                    datatype = this.toModelName(datatype.substring("#/definitions/".length()));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error obtaining the datatype from RefProperty:" + p + ". Datatype default to Object");
                datatype = "Object";
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return datatype;
        }
        if (p instanceof FileProperty) {
            return ((String)this.typeMapping.get("File")).toString();
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public CodegenParameter fromParameter(Parameter param, Set<String> imports) {
        CodegenParameter parameter = super.fromParameter(param, imports);
        if (param instanceof BodyParameter) {
            BodyParameter bp = (BodyParameter)param;
            Model model = bp.getSchema();
            if (model instanceof RefModel) {
                String name = ((RefModel)model).getSimpleRef();
                name = this.toModelName(name);
                parameter.vendorExtensions.put("uppercase_data_type", name.toUpperCase());
                parameter.baseType = name = "models::" + this.getTypeDeclaration(name);
                parameter.dataType = name;
                String refName = ((RefModel)model).get$ref();
                if (refName.indexOf("#/definitions/") == 0) {
                    refName = refName.substring("#/definitions/".length());
                }
                parameter.vendorExtensions.put("refName", refName);
            } else if (model instanceof ModelImpl) {
                parameter.vendorExtensions.put("refName", ((ModelImpl)model).getName());
            }
        }
        return parameter;
    }

    @Override
    public CodegenProperty fromProperty(String name, Property p) {
        CodegenProperty property = super.fromProperty(name, p);
        if (p instanceof RefProperty) {
            property.datatype = "models::" + property.datatype;
        }
        return property;
    }

    @Override
    public String toInstantiationType(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return (String)this.instantiationTypes.get("array") + "<" + this.getSwaggerType(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return (String)this.instantiationTypes.get("map") + "<" + (String)this.typeMapping.get("string") + ", " + this.getSwaggerType(inner) + ">";
        }
        return null;
    }

    @Override
    public CodegenModel fromModel(String name, Model model) {
        return this.fromModel(name, model, null);
    }

    @Override
    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        CodegenModel mdl = super.fromModel(name, model, allDefinitions);
        mdl.vendorExtensions.put("upperCaseName", name.toUpperCase());
        if (model instanceof ModelImpl) {
            ModelImpl modelImpl = (ModelImpl)model;
            mdl.dataType = (String)this.typeMapping.get(modelImpl.getType());
        }
        if (model instanceof ArrayModel) {
            String xmlName;
            ArrayModel am = (ArrayModel)model;
            if (am.getItems() != null && am.getItems().getXml() != null && (xmlName = am.getItems().getXml().getName()) != null) {
                mdl.vendorExtensions.put("itemXmlName", xmlName);
                this.modelXmlNames.put("models::" + mdl.classname, xmlName);
            }
            mdl.arrayModelType = this.toModelName(mdl.arrayModelType);
        }
        if (mdl.xmlNamespace != null) {
            this.additionalProperties.put("usesXmlNamespaces", true);
        }
        return mdl;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        String modelName;
        Map<String, Object> newObjs = super.postProcessAllModels(objs);
        HashMap<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, Object> entry : objs.entrySet()) {
            modelName = this.toModelName(entry.getKey());
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                allModels.put(modelName, cm);
            }
        }
        for (Map.Entry<String, Object> entry : allModels.entrySet()) {
            modelName = entry.getKey();
            CodegenModel model = (CodegenModel)entry.getValue();
            for (CodegenProperty prop : model.vars) {
                String xmlName = this.modelXmlNames.get(prop.datatype);
                if (xmlName == null) continue;
                prop.vendorExtensions.put("itemXmlName", xmlName);
            }
        }
        return newObjs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Swagger swagger = (Swagger)objs.get("swagger");
        if (swagger != null) {
            try {
                objs.put("swagger-yaml", Yaml.mapper().writeValueAsString((Object)swagger));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<Map.Entry<String, Map<String, String>>> pathSetEntryList = new ArrayList<Map.Entry<String, Map<String, String>>>(this.pathSetMap.entrySet());
        Collections.sort(pathSetEntryList, new Comparator<Map.Entry<String, Map<String, String>>>(){

            @Override
            public int compare(Map.Entry<String, Map<String, String>> a, Map.Entry<String, Map<String, String>> b) {
                return a.getValue().get("path").compareTo(b.getValue().get("path"));
            }
        });
        ArrayList<Map> pathSet = new ArrayList<Map>();
        int index = 0;
        for (Map.Entry entry : pathSetEntryList) {
            Map pathSetEntryValue = (Map)entry.getValue();
            pathSetEntryValue.put("index", Integer.toString(index));
            ++index;
            pathSet.add(pathSetEntryValue);
        }
        objs.put("pathSet", pathSet);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String toDefaultValue(Property p) {
        LongProperty dp;
        if (p instanceof StringProperty) {
            StringProperty dp2 = (StringProperty)p;
            if (dp2.getDefault() != null) {
                return "\"" + dp2.getDefault() + "\".to_string()";
            }
        } else if (p instanceof BooleanProperty) {
            BooleanProperty dp3 = (BooleanProperty)p;
            if (dp3.getDefault() != null) {
                if (dp3.getDefault().toString().equalsIgnoreCase("false")) {
                    return "false";
                }
                return "true";
            }
        } else if (p instanceof DoubleProperty) {
            DoubleProperty dp4 = (DoubleProperty)p;
            if (dp4.getDefault() != null) {
                return dp4.getDefault().toString();
            }
        } else if (p instanceof FloatProperty) {
            FloatProperty dp5 = (FloatProperty)p;
            if (dp5.getDefault() != null) {
                return dp5.getDefault().toString();
            }
        } else if (p instanceof IntegerProperty) {
            IntegerProperty dp6 = (IntegerProperty)p;
            if (dp6.getDefault() != null) {
                return dp6.getDefault().toString();
            }
        } else if (p instanceof LongProperty && (dp = (LongProperty)p).getDefault() != null) {
            return dp.getDefault().toString();
        }
        return null;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!this.languageSpecificPrimitives.contains(property.datatype)) {
            if (property.datatype.contains(":")) {
                int position = property.datatype.lastIndexOf(":");
                property.datatype = property.datatype.substring(0, position) + RustServerCodegen.camelize(property.datatype.substring(position));
            } else {
                property.datatype = RustServerCodegen.camelize(property.datatype, false);
            }
        }
        if ("integer".equals(property.baseType)) {
            if ("uint32".equals(property.dataFormat)) {
                property.datatype = "u32";
            } else if ("uint64".equals(property.dataFormat)) {
                property.datatype = "u64";
            } else {
                Long inclusiveMaximum;
                Long inclusiveMinimum;
                Long l = inclusiveMinimum = property.minimum != null ? Long.valueOf(Long.parseLong(property.minimum)) : null;
                if (inclusiveMinimum != null && property.exclusiveMinimum) {
                    Long l2 = inclusiveMinimum;
                    Long l3 = inclusiveMinimum = Long.valueOf(inclusiveMinimum + 1L);
                }
                boolean unsigned = inclusiveMinimum != null && inclusiveMinimum >= 0L;
                Long l4 = inclusiveMaximum = property.maximum != null ? Long.valueOf(Long.parseLong(property.maximum)) : null;
                if (inclusiveMaximum != null && property.exclusiveMaximum) {
                    Object object = inclusiveMaximum;
                    Long l5 = inclusiveMaximum = Long.valueOf(inclusiveMaximum - 1L);
                }
                switch (property.dataFormat == null ? NO_FORMAT : property.dataFormat) {
                    case "int32": {
                        property.datatype = unsigned ? "u32" : "i32";
                        break;
                    }
                    case "int64": {
                        property.datatype = unsigned ? "u64" : "i64";
                        break;
                    }
                    case "%%NO_FORMAT": {
                        property.datatype = RustServerCodegen.matchingIntType(unsigned, inclusiveMinimum, inclusiveMaximum);
                        break;
                    }
                    default: {
                        LOGGER.warn("The integer format '{}' is not recognized and will be ignored.", (Object)property.dataFormat);
                        property.datatype = RustServerCodegen.matchingIntType(unsigned, inclusiveMinimum, inclusiveMaximum);
                    }
                }
            }
        }
        property.name = RustServerCodegen.underscore(property.name);
        if (!property.required) {
            property.defaultValue = property.defaultValue != null ? "Some(" + property.defaultValue + ")" : "None";
        }
    }

    static long requiredBits(Long bound, boolean unsigned) {
        if (bound == null) {
            return 0L;
        }
        if (unsigned) {
            if (bound < 0L) {
                throw new RuntimeException("Unsigned bound is negative: " + bound);
            }
            return 65 - Long.numberOfLeadingZeros(bound >> 1);
        }
        return 65 - Long.numberOfLeadingZeros(bound < 0L ? Math.abs(bound) - 1L : bound);
    }

    static String matchingIntType(boolean unsigned, Long inclusiveMin, Long inclusiveMax) {
        long requiredMinBits = RustServerCodegen.requiredBits(inclusiveMin, unsigned);
        long requiredMaxBits = RustServerCodegen.requiredBits(inclusiveMax, unsigned);
        long requiredBits = Math.max(requiredMinBits, requiredMaxBits);
        if (requiredMaxBits == 0L && requiredMinBits <= 16L) {
            return unsigned ? "usize" : "isize";
        }
        if (requiredBits <= 8L) {
            return unsigned ? "u8" : "i8";
        }
        if (requiredBits <= 16L) {
            return unsigned ? "u16" : "i16";
        }
        if (requiredBits <= 32L) {
            return unsigned ? "u32" : "i32";
        }
        return unsigned ? "u64" : "i64";
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return super.postProcessModelsEnum(objs);
    }

    private boolean paramHasXmlNamespace(CodegenParameter param, Map<String, Model> definitions) {
        Xml xml;
        String name;
        Model model;
        Object refName = param.vendorExtensions.get("refName");
        return refName != null && refName instanceof String && (model = definitions.get(name = (String)refName)) != null && model instanceof ModelImpl && (xml = ((ModelImpl)model).getXml()) != null && xml.getNamespace() != null;
    }

    private void processParam(CodegenParameter param, CodegenOperation op) {
        String example = null;
        if (param.isString) {
            if (param.dataFormat != null && param.dataFormat.equals("byte")) {
                param.vendorExtensions.put("formatString", "\\\"{:?}\\\"");
                example = "swagger::ByteArray(\"" + (param.example != null ? param.example : "") + "\".to_string().into_bytes())";
            } else {
                param.vendorExtensions.put("formatString", "\\\"{}\\\"");
                example = "\"" + (param.example != null ? param.example : "") + "\".to_string()";
            }
        } else if (param.isPrimitiveType) {
            if (param.isByteArray || param.isBinary) {
                param.vendorExtensions.put("formatString", "{:?}");
                example = "swagger::ByteArray(Vec::from(\"" + (param.example != null ? param.example : "") + "\"))";
            } else {
                param.vendorExtensions.put("formatString", "{}");
                example = param.example != null ? param.example : "";
            }
        } else if (param.isListContainer) {
            param.vendorExtensions.put("formatString", "{:?}");
            example = param.example != null ? param.example : "&Vec::new()";
        } else if (param.isFile) {
            param.vendorExtensions.put("formatString", "{:?}");
            op.vendorExtensions.put("hasFile", true);
            this.additionalProperties.put("apiHasFile", true);
            example = "Box::new(stream::once(Ok(b\"hello\".to_vec()))) as Box<Stream<Item=_, Error=_> + Send>";
        } else {
            param.vendorExtensions.put("formatString", "{:?}");
            if (param.example != null) {
                example = "serde_json::from_str::<" + param.dataType + ">(\"" + param.example + "\").expect(\"Failed to parse JSON example\")";
            }
        }
        if (param.required) {
            if (example != null) {
                param.vendorExtensions.put("example", example);
            } else if (param.isListContainer) {
                param.vendorExtensions.put("example", "&Vec::new()");
            } else {
                param.vendorExtensions.put("example", "???");
                op.vendorExtensions.put("noClientExample", Boolean.TRUE);
            }
        } else if (param.dataFormat != null && (param.dataFormat.equals("date-time") || param.dataFormat.equals("date"))) {
            param.vendorExtensions.put("formatString", "{:?}");
            param.vendorExtensions.put("example", "None");
        } else {
            param.vendorExtensions.put("formatString", "{:?}");
            if (param.isFile) {
                param.vendorExtensions.put("example", example != null ? "Box::new(future::ok(Some(" + example + "))) as Box<Future<Item=_, Error=_> + Send>" : "None");
            } else {
                param.vendorExtensions.put("example", example != null ? "Some(" + example + ")" : "None");
            }
        }
    }
}

