/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.discovery;

import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.serviceregistry.discovery.AbstractDiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryContext;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;

public class InstanceStatusDiscoveryFilter
extends AbstractDiscoveryFilter {
    private static final String UP_INSTANCES = "upInstances";

    @Override
    public int getOrder() {
        return -20000;
    }

    @Override
    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.status.enabled", true).get();
    }

    @Override
    public boolean isGroupingFilter() {
        return true;
    }

    @Override
    protected String findChildName(DiscoveryContext context, DiscoveryTreeNode parent) {
        return UP_INSTANCES;
    }

    @Override
    public void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        Map instances = (Map)parent.data();
        HashMap<String, MicroserviceInstance> filteredServers = new HashMap<String, MicroserviceInstance>();
        for (String key : instances.keySet()) {
            MicroserviceInstance instance = (MicroserviceInstance)instances.get(key);
            if (MicroserviceInstanceStatus.UP != instance.getStatus()) continue;
            filteredServers.put(key, instance);
        }
        if (filteredServers.isEmpty()) {
            return;
        }
        DiscoveryTreeNode child = (DiscoveryTreeNode)new DiscoveryTreeNode().subName(parent, UP_INSTANCES).data(filteredServers);
        parent.child(UP_INSTANCES, child);
    }
}

