/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.language.simple.BaseSimpleParser;
import org.apache.camel.language.simple.ast.LiteralExpression;
import org.apache.camel.language.simple.ast.LiteralNode;
import org.apache.camel.language.simple.ast.SimpleFunctionEnd;
import org.apache.camel.language.simple.ast.SimpleFunctionStart;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.ast.UnaryExpression;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.language.simple.types.TokenType;

public class SimpleExpressionParser
extends BaseSimpleParser {
    @Deprecated
    public SimpleExpressionParser(String expression) {
        super(expression, true);
    }

    public SimpleExpressionParser(String expression, boolean allowEscape) {
        super(expression, allowEscape);
    }

    public Expression parseExpression() {
        this.clear();
        try {
            return this.doParseExpression();
        }
        catch (SimpleParserException e) {
            throw new SimpleIllegalSyntaxException(this.expression, e.getIndex(), e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SimpleIllegalSyntaxException(this.expression, -1, e.getMessage(), e);
        }
    }

    protected Expression doParseExpression() {
        this.nextToken();
        while (!this.token.getType().isEol()) {
            this.templateText();
            this.functionText();
            this.unaryOperator();
            this.nextToken();
        }
        this.parseAndCreateAstModel();
        this.prepareBlocks();
        this.prepareUnaryExpressions();
        List<Expression> expressions = this.createExpressions();
        if (expressions.isEmpty()) {
            return ExpressionBuilder.constantExpression("");
        }
        if (expressions.size() == 1) {
            return expressions.get(0);
        }
        return ExpressionBuilder.concatExpression(expressions, this.expression);
    }

    protected void parseAndCreateAstModel() {
        SimpleToken token;
        AtomicInteger functions = new AtomicInteger();
        LiteralNode imageToken = null;
        Iterator i$ = this.tokens.iterator();
        while (i$.hasNext() && !(token = (SimpleToken)i$.next()).getType().isEol()) {
            SimpleNode node = this.createNode(token, functions);
            if (node != null) {
                if (imageToken != null) {
                    this.nodes.add(imageToken);
                    imageToken = null;
                }
                this.nodes.add(node);
                continue;
            }
            if (imageToken == null) {
                imageToken = new LiteralExpression(token);
            }
            imageToken.addText(token.getText());
        }
        if (imageToken != null) {
            this.nodes.add(imageToken);
        }
    }

    private SimpleNode createNode(SimpleToken token, AtomicInteger functions) {
        if (token.getType().isFunctionStart()) {
            functions.incrementAndGet();
            return new SimpleFunctionStart(token);
        }
        if (functions.get() > 0 && token.getType().isFunctionEnd()) {
            functions.decrementAndGet();
            return new SimpleFunctionEnd(token);
        }
        if (token.getType().isUnary() && !this.nodes.isEmpty() && this.nodes.get(this.nodes.size() - 1) instanceof SimpleFunctionEnd) {
            return new UnaryExpression(token);
        }
        return null;
    }

    private List<Expression> createExpressions() {
        ArrayList<Expression> answer = new ArrayList<Expression>();
        for (SimpleNode token : this.nodes) {
            Expression exp = token.createExpression(this.expression);
            if (exp == null) continue;
            answer.add(exp);
        }
        return answer;
    }

    protected void templateText() {
        while (!(this.token.getType().isFunctionStart() || this.token.getType().isFunctionEnd() || this.token.getType().isEol())) {
            this.nextToken();
        }
    }

    protected boolean functionText() {
        if (this.accept(TokenType.functionStart)) {
            this.nextToken();
            while (!this.token.getType().isFunctionEnd() && !this.token.getType().isEol()) {
                if (this.token.getType().isFunctionStart()) {
                    this.functionText();
                }
                this.nextToken();
            }
            if (!this.token.getType().isFunctionStart()) {
                this.expect(TokenType.functionEnd);
            }
            return true;
        }
        return false;
    }

    protected boolean unaryOperator() {
        if (this.accept(TokenType.unaryOperator)) {
            this.nextToken();
            this.expect(TokenType.whiteSpace);
            return true;
        }
        return false;
    }
}

