/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.engine.batch.preparedstatement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.driver.executor.callback.add.StatementAddCallback;
import org.apache.shardingsphere.driver.executor.callback.keygen.GeneratedKeyCallback;
import org.apache.shardingsphere.driver.executor.callback.replay.PreparedStatementParametersReplayCallback;
import org.apache.shardingsphere.driver.executor.engine.batch.preparedstatement.BatchExecutionUnit;
import org.apache.shardingsphere.driver.executor.engine.batch.preparedstatement.BatchPreparedStatementExecutor;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.statement.StatementManager;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.executor.audit.SQLAuditEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class DriverExecuteBatchExecutor {
    private final ShardingSphereConnection connection;
    private final ShardingSphereMetaData metaData;
    private final BatchPreparedStatementExecutor batchPreparedStatementExecutor;
    private final DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine;
    private ExecutionContext executionContext;

    public DriverExecuteBatchExecutor(ShardingSphereConnection connection, ShardingSphereMetaData metaData, StatementOption statementOption, StatementManager statementManager, ShardingSphereDatabase database) {
        this.connection = connection;
        this.metaData = metaData;
        JDBCExecutor jdbcExecutor = new JDBCExecutor(connection.getContextManager().getExecutorEngine(), connection.getDatabaseConnectionManager().getConnectionContext());
        this.batchPreparedStatementExecutor = new BatchPreparedStatementExecutor(database, jdbcExecutor, connection.getProcessId());
        this.prepareEngine = this.createDriverExecutionPrepareEngine(statementOption, statementManager, database);
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine(StatementOption statementOption, StatementManager statementManager, ShardingSphereDatabase database) {
        int maxConnectionsSizePerQuery = (Integer)this.connection.getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine("JDBC.PREPARED_STATEMENT", maxConnectionsSizePerQuery, (DatabaseConnectionManager)this.connection.getDatabaseConnectionManager(), (ExecutorStatementManager)statementManager, (StorageResourceOption)statementOption, database.getRuleMetaData().getRules(), database.getResourceMetaData().getStorageUnits());
    }

    public void addBatch(QueryContext queryContext, ShardingSphereDatabase database) {
        this.executionContext = this.createExecutionContext(queryContext, database);
        this.batchPreparedStatementExecutor.addBatchForExecutionUnits(this.executionContext.getExecutionUnits());
    }

    private ExecutionContext createExecutionContext(QueryContext queryContext, ShardingSphereDatabase database) {
        RuleMetaData globalRuleMetaData = this.metaData.getGlobalRuleMetaData();
        SQLAuditEngine.audit((QueryContext)queryContext, (RuleMetaData)globalRuleMetaData, (ShardingSphereDatabase)database);
        return new KernelProcessor().generateExecutionContext(queryContext, globalRuleMetaData, this.metaData.getProps(), this.connection.getDatabaseConnectionManager().getConnectionContext());
    }

    public int[] executeBatch(ShardingSphereDatabase database, SQLStatementContext sqlStatementContext, Collection<Comparable<?>> generatedValues, StatementOption statementOption, StatementAddCallback addCallback, PreparedStatementParametersReplayCallback replayCallback, GeneratedKeyCallback generatedKeyCallback) throws SQLException {
        if (null == this.executionContext) {
            return new int[0];
        }
        return this.doExecuteBatch(database, this.batchPreparedStatementExecutor, sqlStatementContext, generatedValues, statementOption, this.executionContext, addCallback, replayCallback, generatedKeyCallback);
    }

    private int[] doExecuteBatch(ShardingSphereDatabase database, BatchPreparedStatementExecutor batchExecutor, SQLStatementContext sqlStatementContext, Collection<Comparable<?>> generatedValues, StatementOption statementOption, ExecutionContext executionContext, StatementAddCallback addCallback, PreparedStatementParametersReplayCallback replayCallback, GeneratedKeyCallback generatedKeyCallback) throws SQLException {
        this.initBatchPreparedStatementExecutor(database, batchExecutor, executionContext, replayCallback);
        int[] result = batchExecutor.executeBatch(sqlStatementContext);
        if (statementOption.isReturnGeneratedKeys() && generatedValues.isEmpty()) {
            addCallback.add(batchExecutor.getStatements(), Collections.emptyList());
            generatedKeyCallback.generateKeys();
        }
        return result;
    }

    private void initBatchPreparedStatementExecutor(ShardingSphereDatabase database, BatchPreparedStatementExecutor batchExecutor, ExecutionContext executionContext, PreparedStatementParametersReplayCallback replayCallback) throws SQLException {
        ArrayList<ExecutionUnit> executionUnits = new ArrayList<ExecutionUnit>(batchExecutor.getBatchExecutionUnits().size());
        for (BatchExecutionUnit each : batchExecutor.getBatchExecutionUnits()) {
            ExecutionUnit executionUnit = each.getExecutionUnit();
            executionUnits.add(executionUnit);
        }
        batchExecutor.init((ExecutionGroupContext<JDBCExecutionUnit>)this.prepareEngine.prepare(database.getName(), executionContext.getRouteContext(), executionUnits, new ExecutionGroupReportContext(this.connection.getProcessId(), database.getName())));
        this.setBatchParameters(replayCallback);
    }

    private void setBatchParameters(PreparedStatementParametersReplayCallback replayCallback) throws SQLException {
        for (Statement each : this.batchPreparedStatementExecutor.getStatements()) {
            for (List<Object> eachParams : this.batchPreparedStatementExecutor.getParameterSet(each)) {
                replayCallback.replay((PreparedStatement)each, eachParams);
                ((PreparedStatement)each).addBatch();
            }
        }
    }

    public void clear() {
        this.batchPreparedStatementExecutor.clear();
    }
}

