/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.builder;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlShardingSphereRowData;
import org.apache.shardingsphere.metadata.persist.node.ShardingSphereDataNode;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.DispatchEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.DatabaseDataAddedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.DatabaseDataDeletedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.SchemaDataAddedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.SchemaDataDeletedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.ShardingSphereRowDataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.ShardingSphereRowDataDeletedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.TableDataChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.event.builder.DispatchEventBuilder;

public final class ShardingSphereDataDispatchEventBuilder
implements DispatchEventBuilder<DispatchEvent> {
    @Override
    public String getSubscribedKey() {
        return ShardingSphereDataNode.getShardingSphereDataNodePath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<DispatchEvent> build(DataChangedEvent event) {
        Optional databaseName = ShardingSphereDataNode.getDatabaseName((String)event.getKey());
        if (databaseName.isPresent()) {
            return this.createDatabaseChangedEvent(event, (String)databaseName.get());
        }
        databaseName = ShardingSphereDataNode.getDatabaseNameByDatabasePath((String)event.getKey());
        if (!databaseName.isPresent()) {
            return Optional.empty();
        }
        Optional schemaName = ShardingSphereDataNode.getSchemaName((String)event.getKey());
        if (schemaName.isPresent()) {
            return this.createSchemaChangedEvent(event, (String)databaseName.get(), (String)schemaName.get());
        }
        schemaName = ShardingSphereDataNode.getSchemaNameBySchemaPath((String)event.getKey());
        if (!schemaName.isPresent()) {
            return Optional.empty();
        }
        Optional tableName = ShardingSphereDataNode.getTableName((String)event.getKey());
        if (tableName.isPresent()) {
            return this.createTableChangedEvent(event, (String)databaseName.get(), (String)schemaName.get(), (String)tableName.get());
        }
        tableName = ShardingSphereDataNode.getTableNameByRowPath((String)event.getKey());
        if (!tableName.isPresent()) {
            return Optional.empty();
        }
        Optional rowPath = ShardingSphereDataNode.getRowUniqueKey((String)event.getKey());
        if (rowPath.isPresent()) {
            return this.createRowDataChangedEvent(event, (String)databaseName.get(), (String)schemaName.get(), (String)tableName.get(), (String)rowPath.get());
        }
        return Optional.empty();
    }

    private Optional<DispatchEvent> createDatabaseChangedEvent(DataChangedEvent event, String databaseName) {
        switch (event.getType()) {
            case ADDED: 
            case UPDATED: {
                return Optional.of(new DatabaseDataAddedEvent(databaseName));
            }
            case DELETED: {
                return Optional.of(new DatabaseDataDeletedEvent(databaseName));
            }
        }
        return Optional.empty();
    }

    private Optional<DispatchEvent> createSchemaChangedEvent(DataChangedEvent event, String databaseName, String schemaName) {
        switch (event.getType()) {
            case ADDED: 
            case UPDATED: {
                return Optional.of(new SchemaDataAddedEvent(databaseName, schemaName));
            }
            case DELETED: {
                return Optional.of(new SchemaDataDeletedEvent(databaseName, schemaName));
            }
        }
        return Optional.empty();
    }

    private Optional<DispatchEvent> createTableChangedEvent(DataChangedEvent event, String databaseName, String schemaName, String tableName) {
        switch (event.getType()) {
            case ADDED: 
            case UPDATED: {
                return Optional.of(new TableDataChangedEvent(databaseName, schemaName, tableName, null));
            }
            case DELETED: {
                return Optional.of(new TableDataChangedEvent(databaseName, schemaName, null, tableName));
            }
        }
        return Optional.empty();
    }

    private Optional<DispatchEvent> createRowDataChangedEvent(DataChangedEvent event, String databaseName, String schemaName, String tableName, String rowPath) {
        if (!(DataChangedEvent.Type.ADDED != event.getType() && DataChangedEvent.Type.UPDATED != event.getType() || Strings.isNullOrEmpty((String)event.getValue()))) {
            return Optional.of(new ShardingSphereRowDataChangedEvent(databaseName, schemaName, tableName, (YamlShardingSphereRowData)YamlEngine.unmarshal((String)event.getValue(), YamlShardingSphereRowData.class)));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new ShardingSphereRowDataDeletedEvent(databaseName, schemaName, tableName, rowPath));
        }
        return Optional.empty();
    }
}

