/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.pojo;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Substitutable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;

public final class EncryptPredicateFunctionRightValueToken
extends SQLToken
implements Substitutable {
    private static final String COMMA_SEPARATOR = ", ";
    private final int stopIndex;
    private final String functionName;
    private final Collection<ExpressionSegment> parameters;
    private final Map<Integer, Object> indexValues;
    private final Collection<Integer> paramMarkerIndexes;

    public EncryptPredicateFunctionRightValueToken(int startIndex, int stopIndex, String functionName, Collection<ExpressionSegment> parameters, Map<Integer, Object> indexValues, Collection<Integer> paramMarkerIndexes) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.functionName = functionName;
        this.parameters = parameters;
        this.indexValues = indexValues;
        this.paramMarkerIndexes = paramMarkerIndexes;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        AtomicInteger parameterIndex = new AtomicInteger();
        this.appendFunctionSegment(this.functionName, this.parameters, result, parameterIndex);
        return result.toString();
    }

    private void appendFunctionSegment(String functionName, Collection<ExpressionSegment> parameters, StringBuilder builder, AtomicInteger parameterIndex) {
        builder.append(functionName).append(" (");
        for (ExpressionSegment each : parameters) {
            if (each instanceof FunctionSegment) {
                this.appendFunctionSegment(((FunctionSegment)each).getFunctionName(), ((FunctionSegment)each).getParameters(), builder, parameterIndex);
                continue;
            }
            this.appendRewrittenParameters(builder, parameterIndex.getAndIncrement());
        }
        if (builder.toString().endsWith(COMMA_SEPARATOR)) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append(')');
    }

    private void appendRewrittenParameters(StringBuilder builder, int parameterIndex) {
        if (this.paramMarkerIndexes.contains(parameterIndex)) {
            builder.append('?');
        } else if (this.indexValues.get(parameterIndex) instanceof String) {
            builder.append('\'').append(this.indexValues.get(parameterIndex)).append('\'');
        } else {
            builder.append(this.indexValues.get(parameterIndex));
        }
        builder.append(COMMA_SEPARATOR);
    }

    public boolean equals(Object obj) {
        return obj instanceof EncryptPredicateFunctionRightValueToken && ((EncryptPredicateFunctionRightValueToken)((Object)obj)).getStartIndex() == this.getStartIndex() && ((EncryptPredicateFunctionRightValueToken)((Object)obj)).getStopIndex() == this.stopIndex && ((EncryptPredicateFunctionRightValueToken)((Object)obj)).indexValues.equals(this.indexValues) && ((EncryptPredicateFunctionRightValueToken)((Object)obj)).paramMarkerIndexes.equals(this.paramMarkerIndexes);
    }

    public int hashCode() {
        return Objects.hash(this.getStartIndex(), this.stopIndex, this.indexValues, this.paramMarkerIndexes);
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

