/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.service.config.database;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.metadata.persist.node.metadata.DataSourceMetaDataNode;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class DataSourceNodePersistService {
    private final PersistRepository repository;

    public Map<String, DataSourcePoolProperties> load(String databaseName) {
        List childrenKeys = this.repository.getChildrenKeys(DataSourceMetaDataNode.getDataSourceNodesNode(databaseName));
        LinkedHashMap<String, DataSourcePoolProperties> result = new LinkedHashMap<String, DataSourcePoolProperties>(childrenKeys.size(), 1.0f);
        for (String each : childrenKeys) {
            String dataSourceValue = this.repository.query(DataSourceMetaDataNode.getDataSourceNodeVersionNode(databaseName, each, this.getDataSourceActiveVersion(databaseName, each)));
            if (Strings.isNullOrEmpty((String)dataSourceValue)) continue;
            result.put(each, new YamlDataSourceConfigurationSwapper().swapToDataSourcePoolProperties((Map)YamlEngine.unmarshal((String)dataSourceValue, Map.class)));
        }
        return result;
    }

    public DataSourcePoolProperties load(String databaseName, String dataSourceName) {
        String dataSourceValue = this.repository.query(DataSourceMetaDataNode.getDataSourceNodeVersionNode(databaseName, dataSourceName, this.getDataSourceActiveVersion(databaseName, dataSourceName)));
        return new YamlDataSourceConfigurationSwapper().swapToDataSourcePoolProperties((Map)YamlEngine.unmarshal((String)dataSourceValue, Map.class));
    }

    public void persist(String databaseName, Map<String, DataSourcePoolProperties> dataSourceConfigs) {
        for (Map.Entry<String, DataSourcePoolProperties> entry : dataSourceConfigs.entrySet()) {
            List versions;
            String activeVersion = this.getDataSourceActiveVersion(databaseName, entry.getKey());
            this.repository.persist(DataSourceMetaDataNode.getDataSourceNodeVersionNode(databaseName, entry.getKey(), (versions = this.repository.getChildrenKeys(DataSourceMetaDataNode.getDataSourceNodeVersionsNode(databaseName, entry.getKey()))).isEmpty() ? "0" : String.valueOf(Integer.parseInt((String)versions.get(0)) + 1)), YamlEngine.marshal((Object)new YamlDataSourceConfigurationSwapper().swapToMap(entry.getValue())));
            if (!Strings.isNullOrEmpty((String)activeVersion)) continue;
            this.repository.persist(DataSourceMetaDataNode.getDataSourceNodeActiveVersionNode(databaseName, entry.getKey()), "0");
        }
    }

    private String getDataSourceActiveVersion(String databaseName, String dataSourceName) {
        return this.repository.query(DataSourceMetaDataNode.getDataSourceNodeActiveVersionNode(databaseName, dataSourceName));
    }

    public void delete(String databaseName, String dataSourceName) {
        this.repository.delete(DataSourceMetaDataNode.getDataSourceNodeNode(databaseName, dataSourceName));
    }

    @Generated
    public DataSourceNodePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

