/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.props.domain;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.custom.CustomDataSourcePoolProperties;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.synonym.ConnectionPropertySynonyms;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.synonym.PoolPropertySynonyms;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class DataSourcePoolProperties {
    private final String poolClassName;
    private final ConnectionPropertySynonyms connectionPropertySynonyms;
    private final PoolPropertySynonyms poolPropertySynonyms;
    private final CustomDataSourcePoolProperties customProperties;

    public DataSourcePoolProperties(String poolClassName, Map<String, Object> props) {
        Optional metaData = TypedSPILoader.findService(DataSourcePoolMetaData.class, (Object)poolClassName);
        this.poolClassName = metaData.map(optional -> optional.getType().toString()).orElse(poolClassName);
        Map<String, String> propertySynonyms = metaData.map(DataSourcePoolMetaData::getPropertySynonyms).orElse(Collections.emptyMap());
        this.connectionPropertySynonyms = new ConnectionPropertySynonyms(props, propertySynonyms);
        this.poolPropertySynonyms = new PoolPropertySynonyms(props, propertySynonyms);
        Collection transientFieldNames = metaData.map(DataSourcePoolMetaData::getTransientFieldNames).orElse(Collections.emptyList());
        this.customProperties = new CustomDataSourcePoolProperties(props, this.getStandardPropertyKeys(), transientFieldNames, propertySynonyms);
    }

    private Collection<String> getStandardPropertyKeys() {
        LinkedList<String> result = new LinkedList<String>(this.connectionPropertySynonyms.getStandardPropertyKeys());
        result.addAll(this.poolPropertySynonyms.getStandardPropertyKeys());
        return result;
    }

    public Map<String, Object> getAllStandardProperties() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.connectionPropertySynonyms.getStandardProperties().size() + this.poolPropertySynonyms.getStandardProperties().size() + this.customProperties.getProperties().size(), 1.0f);
        result.putAll(this.connectionPropertySynonyms.getStandardProperties());
        result.putAll(this.poolPropertySynonyms.getStandardProperties());
        result.putAll(this.customProperties.getProperties());
        return result;
    }

    public Map<String, Object> getAllLocalProperties() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.connectionPropertySynonyms.getLocalProperties().size() + this.poolPropertySynonyms.getLocalProperties().size() + this.customProperties.getProperties().size(), 1.0f);
        result.putAll(this.connectionPropertySynonyms.getLocalProperties());
        result.putAll(this.poolPropertySynonyms.getLocalProperties());
        result.putAll(this.customProperties.getProperties());
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj || null != obj && this.getClass() == obj.getClass() && this.equalsByProperties((DataSourcePoolProperties)obj);
    }

    private boolean equalsByProperties(DataSourcePoolProperties props) {
        return this.poolClassName.equals(props.poolClassName) && this.equalsByLocalProperties(props.getAllLocalProperties());
    }

    private boolean equalsByLocalProperties(Map<String, Object> localProps) {
        for (Map.Entry<String, Object> entry : this.getAllLocalProperties().entrySet()) {
            if (!localProps.containsKey(entry.getKey())) continue;
            if (entry.getValue() instanceof Map) {
                return entry.getValue().equals(localProps.get(entry.getKey()));
            }
            if (String.valueOf(entry.getValue()).equals(String.valueOf(localProps.get(entry.getKey())))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.getAllLocalProperties().entrySet()) {
            stringBuilder.append(entry.getKey()).append(entry.getValue());
        }
        return Objects.hashCode((Object[])new Object[]{this.poolClassName, stringBuilder.toString()});
    }

    @Generated
    public String getPoolClassName() {
        return this.poolClassName;
    }

    @Generated
    public ConnectionPropertySynonyms getConnectionPropertySynonyms() {
        return this.connectionPropertySynonyms;
    }

    @Generated
    public PoolPropertySynonyms getPoolPropertySynonyms() {
        return this.poolPropertySynonyms;
    }

    @Generated
    public CustomDataSourcePoolProperties getCustomProperties() {
        return this.customProperties;
    }
}

