/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata.reviser.schema;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.data.model.TableMetaData;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.RuleAndStorageMetaDataMismatchedException;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.schema.SchemaTableAggregationReviser;
import org.apache.shardingsphere.sharding.metadata.TableMetaDataViolation;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShardingSchemaTableAggregationReviser
implements SchemaTableAggregationReviser<ShardingRule> {
    private final boolean checkTableMetaDataEnabled;
    private final Map<String, Collection<TableMetaData>> tableMetaDataMap = new LinkedHashMap<String, Collection<TableMetaData>>();

    public void add(TableMetaData metaData) {
        this.tableMetaDataMap.computeIfAbsent(metaData.getName(), key -> new LinkedList()).add(metaData);
    }

    public Collection<TableMetaData> aggregate(ShardingRule rule) {
        LinkedList<TableMetaData> result = new LinkedList<TableMetaData>();
        for (Map.Entry<String, Collection<TableMetaData>> entry : this.tableMetaDataMap.entrySet()) {
            if (this.checkTableMetaDataEnabled) {
                this.checkUniformed(entry.getKey(), entry.getValue());
            }
            result.add(entry.getValue().iterator().next());
        }
        return result;
    }

    private void checkUniformed(String logicTableName, Collection<TableMetaData> tableMetaDataList) {
        TableMetaData sample = tableMetaDataList.iterator().next();
        Collection violations = tableMetaDataList.stream().filter(each -> !sample.equals(each)).map(each -> new TableMetaDataViolation(each.getName(), (TableMetaData)each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)violations, () -> new RuleAndStorageMetaDataMismatchedException(this.createErrorReason(logicTableName, violations)));
    }

    private String createErrorReason(String logicTableName, Collection<TableMetaDataViolation> violations) {
        StringBuilder result = new StringBuilder("Can not get uniformed table structure for logic table '%s', it has different meta data of actual tables are as follows: ").append(System.lineSeparator());
        for (TableMetaDataViolation each : violations) {
            result.append("actual table: ").append(each.getActualTableName()).append(", meta data: ").append(each.getTableMetaData()).append(System.lineSeparator());
        }
        return String.format(result.toString(), logicTableName);
    }

    @Generated
    public ShardingSchemaTableAggregationReviser(boolean checkTableMetaDataEnabled) {
        this.checkTableMetaDataEnabled = checkTableMetaDataEnabled;
    }
}

