/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.validator;

import com.google.common.base.Preconditions;
import java.util.Properties;
import lombok.Generated;

public final class JobPropertiesValidateRule {
    public static void validateIsRequired(Properties props, String key) {
        Preconditions.checkNotNull((Object)props.getProperty(key), (String)"The property `%s` is required.", (Object)key);
    }

    public static void validateIsPositiveInteger(Properties props, String key) {
        String propertyValue = props.getProperty(key);
        if (null != propertyValue) {
            int integerValue;
            try {
                integerValue = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException ignored) {
                throw new IllegalArgumentException(String.format("The property `%s` should be integer.", key));
            }
            Preconditions.checkArgument((integerValue > 0 ? 1 : 0) != 0, (String)"The property `%s` should be positive.", (Object)key);
        }
    }

    @Generated
    private JobPropertiesValidateRule() {
    }
}

