/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.channel.memory;

import java.util.Properties;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannelAckCallback;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannelCreator;
import org.apache.shardingsphere.data.pipeline.core.channel.memory.MemoryPipelineChannel;

public final class MemoryPipelineChannelCreator
implements PipelineChannelCreator {
    private static final String BLOCK_QUEUE_SIZE_KEY = "block-queue-size";
    private static final String BLOCK_QUEUE_SIZE_DEFAULT_VALUE = "2000";
    private int queueSize;

    public void init(Properties props) {
        this.queueSize = Integer.parseInt(props.getProperty(BLOCK_QUEUE_SIZE_KEY, BLOCK_QUEUE_SIZE_DEFAULT_VALUE));
    }

    @Override
    public PipelineChannel newInstance(int importerBatchSize, PipelineChannelAckCallback ackCallback) {
        int queueSize = this.queueSize / importerBatchSize;
        return new MemoryPipelineChannel(queueSize, ackCallback);
    }

    public String getType() {
        return "MEMORY";
    }
}

