/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.DataConsistencyCheckUtils;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.RecordSingleTableInventoryCalculatedResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.SingleTableInventoryCalculatedResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.AbstractStreamingSingleTableInventoryCalculator;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.CalculationContext;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.SingleTableInventoryCalculateParameter;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobCancelingException;
import org.apache.shardingsphere.data.pipeline.core.exception.data.PipelineTableDataConsistencyCheckLoadingFailedException;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.QueryRange;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.QueryType;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.column.InventoryColumnValueReaderEngine;
import org.apache.shardingsphere.data.pipeline.core.query.JDBCStreamQueryBuilder;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql.PipelineDataConsistencyCalculateSQLBuilder;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.kernel.category.PipelineSQLException;
import org.apache.shardingsphere.infra.util.close.QuietlyCloser;

public final class RecordSingleTableInventoryCalculator
extends AbstractStreamingSingleTableInventoryCalculator {
    private final int chunkSize;

    @Override
    public Optional<SingleTableInventoryCalculatedResult> calculateChunk(SingleTableInventoryCalculateParameter param) {
        List<Map<String, Object>> records = this.calculateChunk(param, QueryType.RANGE_QUERY == param.getQueryType());
        if (records.isEmpty()) {
            return Optional.empty();
        }
        String firstUniqueKey = param.getFirstUniqueKey().getName();
        if (QueryType.POINT_QUERY == param.getQueryType()) {
            return this.convertRecordsToResult(records, firstUniqueKey);
        }
        if (records.size() == this.chunkSize) {
            Object minUniqueKeyValue = DataConsistencyCheckUtils.getFirstUniqueKeyValue(records.get(0), firstUniqueKey);
            this.removeLastRecords(records, param);
            if (!records.isEmpty()) {
                this.updateQueryRangeLower(param, records, firstUniqueKey);
                return this.convertRecordsToResult(records, firstUniqueKey);
            }
            SingleTableInventoryCalculateParameter newParam = this.buildNewCalculateParameter(param, minUniqueKeyValue);
            records = this.calculateChunk(newParam, false);
            if (!records.isEmpty()) {
                this.updateQueryRangeLower(param, records, firstUniqueKey);
                return this.convertRecordsToResult(records, firstUniqueKey);
            }
            return Optional.empty();
        }
        this.updateQueryRangeLower(param, records, firstUniqueKey);
        return this.convertRecordsToResult(records, firstUniqueKey);
    }

    private List<Map<String, Object>> calculateChunk(SingleTableInventoryCalculateParameter param, boolean isRangeQuery) {
        CalculationContext calculationContext = this.getOrCreateCalculationContext(param);
        try {
            LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
            InventoryColumnValueReaderEngine columnValueReaderEngine = new InventoryColumnValueReaderEngine(param.getDatabaseType());
            ResultSet resultSet = calculationContext.getResultSet();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                ShardingSpherePreconditions.checkState((!this.isCanceling() ? 1 : 0) != 0, () -> new PipelineJobCancelingException("Calculate chunk canceled, schema name: %s, table name: %s", param.getSchemaName(), param.getLogicTableName()));
                LinkedHashMap<String, Object> columnRecord = new LinkedHashMap<String, Object>();
                int columnCount = resultSetMetaData.getColumnCount();
                for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                    columnRecord.put(resultSetMetaData.getColumnLabel(columnIndex), columnValueReaderEngine.read(resultSet, resultSetMetaData, columnIndex));
                }
                result.add(columnRecord);
                if (!isRangeQuery || result.size() != this.chunkSize) continue;
                break;
            }
            LinkedList<Map<String, Object>> linkedList = result;
            if (calculationContext != null) {
                calculationContext.close();
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            try {
                if (calculationContext != null) {
                    try {
                        calculationContext.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (PipelineJobCancelingException | PipelineSQLException ex) {
                throw ex;
            }
            catch (RuntimeException | SQLException ex) {
                throw new PipelineTableDataConsistencyCheckLoadingFailedException(param.getSchemaName(), param.getLogicTableName(), ex);
            }
        }
    }

    private CalculationContext getOrCreateCalculationContext(SingleTableInventoryCalculateParameter param) {
        CalculationContext result = (CalculationContext)param.getCalculationContext();
        if (null != result && !result.isClosed()) {
            return result;
        }
        try {
            result = this.createCalculationContext(param);
            this.fulfillCalculationContext(result, param);
        }
        catch (RuntimeException | SQLException ex) {
            QuietlyCloser.close((AutoCloseable)result);
            throw new PipelineTableDataConsistencyCheckLoadingFailedException(param.getSchemaName(), param.getLogicTableName(), ex);
        }
        return result;
    }

    private CalculationContext createCalculationContext(SingleTableInventoryCalculateParameter param) throws SQLException {
        Connection connection = param.getDataSource().getConnection();
        CalculationContext result = new CalculationContext();
        result.setConnection(connection);
        param.setCalculationContext(result);
        return result;
    }

    private void fulfillCalculationContext(CalculationContext calculationContext, SingleTableInventoryCalculateParameter param) throws SQLException {
        String sql = this.getQuerySQL(param);
        PreparedStatement preparedStatement = JDBCStreamQueryBuilder.build(param.getDatabaseType(), calculationContext.getConnection(), sql, this.chunkSize);
        this.setCurrentStatement(preparedStatement);
        calculationContext.setPreparedStatement(preparedStatement);
        this.setParameters(preparedStatement, param);
        ResultSet resultSet = preparedStatement.executeQuery();
        calculationContext.setResultSet(resultSet);
    }

    private String getQuerySQL(SingleTableInventoryCalculateParameter param) {
        ShardingSpherePreconditions.checkNotNull((Object)param.getFirstUniqueKey(), () -> new UnsupportedOperationException("Record inventory calculator does not support table without unique key and primary key now."));
        PipelineDataConsistencyCalculateSQLBuilder pipelineSQLBuilder = new PipelineDataConsistencyCalculateSQLBuilder(param.getDatabaseType());
        Collection<String> columnNames = param.getColumnNames().isEmpty() ? Collections.singleton("*") : param.getColumnNames();
        switch (param.getQueryType()) {
            case RANGE_QUERY: {
                return pipelineSQLBuilder.buildQueryRangeOrderingSQL(param.getSchemaName(), param.getLogicTableName(), columnNames, param.getUniqueKeysNames(), param.getQueryRange(), param.getShardingColumnsNames());
            }
            case POINT_QUERY: {
                return pipelineSQLBuilder.buildPointQuerySQL(param.getSchemaName(), param.getLogicTableName(), columnNames, param.getUniqueKeysNames(), param.getShardingColumnsNames());
            }
        }
        throw new UnsupportedOperationException("Query type: " + (Object)((Object)param.getQueryType()));
    }

    private void setParameters(PreparedStatement preparedStatement, SingleTableInventoryCalculateParameter param) throws SQLException {
        QueryType queryType = param.getQueryType();
        if (queryType == QueryType.RANGE_QUERY) {
            QueryRange queryRange = param.getQueryRange();
            ShardingSpherePreconditions.checkNotNull((Object)queryRange, () -> new PipelineTableDataConsistencyCheckLoadingFailedException(param.getSchemaName(), param.getLogicTableName(), new RuntimeException("Unique keys values range is null.")));
            int parameterIndex = 1;
            if (null != queryRange.getLower()) {
                preparedStatement.setObject(parameterIndex++, queryRange.getLower());
            }
            if (null != queryRange.getUpper()) {
                preparedStatement.setObject(parameterIndex++, queryRange.getUpper());
            }
            preparedStatement.setObject(parameterIndex, this.chunkSize);
        } else if (queryType == QueryType.POINT_QUERY) {
            Collection<Object> uniqueKeysValues = param.getUniqueKeysValues();
            ShardingSpherePreconditions.checkNotNull(uniqueKeysValues, () -> new PipelineTableDataConsistencyCheckLoadingFailedException(param.getSchemaName(), param.getLogicTableName(), new RuntimeException("Unique keys values is null.")));
            int parameterIndex = 1;
            for (Object each : uniqueKeysValues) {
                preparedStatement.setObject(parameterIndex++, each);
            }
            if (null != param.getShardingColumnsNames() && !param.getShardingColumnsNames().isEmpty()) {
                List<Object> shardingColumnsValues = param.getShardingColumnsValues();
                ShardingSpherePreconditions.checkNotNull(shardingColumnsValues, () -> new PipelineTableDataConsistencyCheckLoadingFailedException(param.getSchemaName(), param.getLogicTableName(), new RuntimeException("Sharding columns values is null when names not empty.")));
                for (Object each : shardingColumnsValues) {
                    preparedStatement.setObject(parameterIndex++, each);
                }
            }
        } else {
            throw new UnsupportedOperationException("Query type: " + (Object)((Object)queryType));
        }
    }

    private void removeLastRecords(List<Map<String, Object>> records, SingleTableInventoryCalculateParameter param) {
        Object maxUniqueKeyValue;
        Object minUniqueKeyValue = DataConsistencyCheckUtils.getFirstUniqueKeyValue(records.get(0), param.getFirstUniqueKey().getName());
        if (Objects.equals(minUniqueKeyValue, maxUniqueKeyValue = DataConsistencyCheckUtils.getFirstUniqueKeyValue(records.get(records.size() - 1), param.getFirstUniqueKey().getName()))) {
            records.clear();
            return;
        }
        records.remove(records.size() - 1);
        for (int i = records.size() - 1; i >= 0 && Objects.deepEquals(maxUniqueKeyValue, DataConsistencyCheckUtils.getFirstUniqueKeyValue(records.get(i), param.getFirstUniqueKey().getName())); --i) {
            records.remove(i);
        }
    }

    private Optional<SingleTableInventoryCalculatedResult> convertRecordsToResult(List<Map<String, Object>> records, String firstUniqueKey) {
        Object maxUniqueKeyValue = DataConsistencyCheckUtils.getFirstUniqueKeyValue(records.get(records.size() - 1), firstUniqueKey);
        return Optional.of(new RecordSingleTableInventoryCalculatedResult(maxUniqueKeyValue, records));
    }

    private SingleTableInventoryCalculateParameter buildNewCalculateParameter(SingleTableInventoryCalculateParameter param, Object minUniqueKeyValue) {
        SingleTableInventoryCalculateParameter result = new SingleTableInventoryCalculateParameter(param.getDataSource(), param.getTable(), param.getColumnNames(), Collections.singletonList(param.getFirstUniqueKey()), QueryType.POINT_QUERY);
        result.setUniqueKeysValues(Collections.singletonList(minUniqueKeyValue));
        result.setShardingColumnsNames(param.getShardingColumnsNames());
        result.setShardingColumnsValues(param.getShardingColumnsValues());
        return result;
    }

    private void updateQueryRangeLower(SingleTableInventoryCalculateParameter param, List<Map<String, Object>> records, String firstUniqueKey) {
        Object maxUniqueKeyValue = DataConsistencyCheckUtils.getFirstUniqueKeyValue(records.get(records.size() - 1), firstUniqueKey);
        param.setQueryRange(new QueryRange(maxUniqueKeyValue, false, param.getQueryRange().getUpper()));
    }

    @Generated
    public RecordSingleTableInventoryCalculator(int chunkSize) {
        this.chunkSize = chunkSize;
    }
}

