/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.context;

import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;

public final class PipelineContextKey {
    private final String databaseName;
    private final InstanceType instanceType;

    public PipelineContextKey(InstanceType instanceType) {
        this("", instanceType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineContextKey that = (PipelineContextKey)o;
        return this.instanceType == that.instanceType && Objects.equals(this.filterDatabaseName(this), this.filterDatabaseName(that));
    }

    private String filterDatabaseName(PipelineContextKey contextKey) {
        return InstanceType.PROXY == contextKey.getInstanceType() ? "" : contextKey.getDatabaseName();
    }

    public int hashCode() {
        return Objects.hash(this.instanceType, this.filterDatabaseName(this));
    }

    @Generated
    public PipelineContextKey(String databaseName, InstanceType instanceType) {
        this.databaseName = databaseName;
        this.instanceType = instanceType;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public InstanceType getInstanceType() {
        return this.instanceType;
    }
}

