/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.datanode;

import com.google.common.base.Splitter;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.kernel.metadata.datanode.InvalidDataNodeFormatException;

public final class DataNodeUtils {
    public static String formatWithSchema(DataNode dataNode) {
        return dataNode.getDataSourceName() + (null != dataNode.getSchemaName() ? "." + dataNode.getSchemaName() : "") + "." + dataNode.getTableName();
    }

    public static DataNode parseWithSchema(String text) {
        boolean hasSchema;
        List segments = Splitter.on((String)".").splitToList((CharSequence)text);
        boolean bl = hasSchema = 3 == segments.size();
        if (2 != segments.size() && !hasSchema) {
            throw new InvalidDataNodeFormatException(text);
        }
        DataNode result = new DataNode((String)segments.get(0), (String)segments.get(segments.size() - 1));
        if (hasSchema) {
            result.setSchemaName((String)segments.get(1));
        }
        return result;
    }

    @Generated
    private DataNodeUtils() {
    }
}

