/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.datanode;

import com.google.common.base.Splitter;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.datanode.DataNodeUtils;
import org.apache.shardingsphere.infra.datanode.DataNode;

public final class JobDataNodeEntry {
    private final String logicTableName;
    private final List<DataNode> dataNodes;

    public static JobDataNodeEntry unmarshal(String text) {
        List segments = Splitter.on((String)":").splitToList((CharSequence)text);
        String logicTableName = (String)segments.get(0);
        LinkedList<DataNode> dataNodes = new LinkedList<DataNode>();
        for (String each : Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)segments.get(1))) {
            dataNodes.add(DataNodeUtils.parseWithSchema(each));
        }
        return new JobDataNodeEntry(logicTableName, dataNodes);
    }

    public String marshal() {
        StringBuilder result = new StringBuilder();
        result.append(this.logicTableName).append(':');
        for (DataNode each : this.dataNodes) {
            result.append(DataNodeUtils.formatWithSchema(each)).append(',');
        }
        if (!this.dataNodes.isEmpty()) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    @Generated
    public JobDataNodeEntry(String logicTableName, List<DataNode> dataNodes) {
        this.logicTableName = logicTableName;
        this.dataNodes = dataNodes;
    }

    @Generated
    public String getLogicTableName() {
        return this.logicTableName;
    }

    @Generated
    public List<DataNode> getDataNodes() {
        return this.dataNodes;
    }
}

