/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.generator;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.dialect.DialectPipelineSQLBuilder;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.AlterTableStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CommentStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CreateIndexStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CreateTableStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.ConstraintAvailable;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineDDLGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineDDLGenerator.class);
    private static final String SET_SEARCH_PATH_PREFIX = "set search_path";

    public List<String> generateLogicDDL(DatabaseType databaseType, DataSource sourceDataSource, String schemaName, String sourceTableName, String targetTableName, SQLParserEngine parserEngine) throws SQLException {
        long startTimeMillis = System.currentTimeMillis();
        ArrayList<String> result = new ArrayList<String>();
        for (String each : ((DialectPipelineSQLBuilder)DatabaseTypedSPILoader.getService(DialectPipelineSQLBuilder.class, (DatabaseType)databaseType)).buildCreateTableSQLs(sourceDataSource, schemaName, sourceTableName)) {
            Optional<String> queryContext = this.decorate(databaseType, sourceDataSource, schemaName, targetTableName, parserEngine, each);
            queryContext.ifPresent(sql -> {
                String trimmedSql = sql.trim();
                if (!Strings.isNullOrEmpty((String)trimmedSql)) {
                    result.add(trimmedSql);
                }
            });
        }
        log.info("generateLogicDDL, databaseType={}, schemaName={}, sourceTableName={}, targetTableName={}, cost {} ms", new Object[]{databaseType.getType(), schemaName, sourceTableName, targetTableName, System.currentTimeMillis() - startTimeMillis});
        return result;
    }

    private Optional<String> decorate(DatabaseType databaseType, DataSource dataSource, String schemaName, String targetTableName, SQLParserEngine parserEngine, String sql) throws SQLException {
        String databaseName;
        if (Strings.isNullOrEmpty((String)sql)) {
            return Optional.empty();
        }
        try (Connection connection = dataSource.getConnection();){
            databaseName = connection.getCatalog();
        }
        String result = this.decorateActualSQL(databaseName, targetTableName, parserEngine, sql.trim());
        if ("openGauss".equals(databaseType.getType())) {
            return this.decorateOpenGauss(databaseName, schemaName, result, parserEngine);
        }
        return Optional.of(result);
    }

    private String decorateActualSQL(String databaseName, String targetTableName, SQLParserEngine parserEngine, String sql) {
        SQLStatementContext sqlStatementContext = this.parseSQL(databaseName, parserEngine, sql);
        TreeMap<SQLSegment, String> replaceMap = new TreeMap<SQLSegment, String>(Comparator.comparing(SQLSegment::getStartIndex));
        if (sqlStatementContext instanceof CreateTableStatementContext) {
            this.appendFromIndexAndConstraint(replaceMap, targetTableName, sqlStatementContext);
            this.appendFromTable(replaceMap, targetTableName, (TableAvailable)sqlStatementContext);
        }
        if (sqlStatementContext instanceof CommentStatementContext) {
            this.appendFromTable(replaceMap, targetTableName, (TableAvailable)sqlStatementContext);
        }
        if (sqlStatementContext instanceof CreateIndexStatementContext) {
            this.appendFromTable(replaceMap, targetTableName, (TableAvailable)sqlStatementContext);
            this.appendFromIndexAndConstraint(replaceMap, targetTableName, sqlStatementContext);
        }
        if (sqlStatementContext instanceof AlterTableStatementContext) {
            this.appendFromIndexAndConstraint(replaceMap, targetTableName, sqlStatementContext);
            this.appendFromTable(replaceMap, targetTableName, (TableAvailable)sqlStatementContext);
        }
        return this.doDecorateActualTable(replaceMap, sql);
    }

    private SQLStatementContext parseSQL(String databaseName, SQLParserEngine parserEngine, String sql) {
        return new SQLBindEngine(null, databaseName, new HintValueContext()).bind(parserEngine.parse(sql, true), Collections.emptyList());
    }

    private void appendFromIndexAndConstraint(Map<SQLSegment, String> replaceMap, String targetTableName, SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof TableAvailable) || ((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().isEmpty()) {
            return;
        }
        TableNameSegment tableNameSegment = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().iterator().next()).getTableName();
        if (!tableNameSegment.getIdentifier().getValue().equals(targetTableName)) {
            if (sqlStatementContext instanceof IndexAvailable) {
                for (IndexSegment each : ((IndexAvailable)sqlStatementContext).getIndexes()) {
                    String logicIndexName = IndexMetaDataUtils.getLogicIndexName((String)each.getIndexName().getIdentifier().getValue(), (String)tableNameSegment.getIdentifier().getValue());
                    replaceMap.put((SQLSegment)each.getIndexName(), logicIndexName);
                }
            }
            if (sqlStatementContext instanceof ConstraintAvailable) {
                for (IndexSegment each : ((ConstraintAvailable)sqlStatementContext).getConstraints()) {
                    String logicConstraint = IndexMetaDataUtils.getLogicIndexName((String)each.getIdentifier().getValue(), (String)tableNameSegment.getIdentifier().getValue());
                    replaceMap.put((SQLSegment)each, logicConstraint);
                }
            }
        }
    }

    private void appendFromTable(Map<SQLSegment, String> replaceMap, String targetTableName, TableAvailable sqlStatementContext) {
        for (SimpleTableSegment each : sqlStatementContext.getTablesContext().getSimpleTables()) {
            if (targetTableName.equals(each.getTableName().getIdentifier().getValue())) continue;
            replaceMap.put((SQLSegment)each.getTableName(), targetTableName);
        }
    }

    private String doDecorateActualTable(Map<SQLSegment, String> replaceMap, String sql) {
        StringBuilder result = new StringBuilder();
        int lastStopIndex = 0;
        for (Map.Entry<SQLSegment, String> entry : replaceMap.entrySet()) {
            result.append(sql, lastStopIndex, entry.getKey().getStartIndex());
            result.append(entry.getValue());
            lastStopIndex = entry.getKey().getStopIndex() + 1;
        }
        if (lastStopIndex < sql.length()) {
            result.append(sql, lastStopIndex, sql.length());
        }
        return result.toString();
    }

    private Optional<String> decorateOpenGauss(String databaseName, String schemaName, String queryContext, SQLParserEngine parserEngine) {
        if (queryContext.toLowerCase().startsWith(SET_SEARCH_PATH_PREFIX)) {
            return Optional.empty();
        }
        return Optional.of(this.replaceTableNameWithPrefix(queryContext, schemaName + ".", databaseName, parserEngine));
    }

    private String replaceTableNameWithPrefix(String sql, String prefix, String databaseName, SQLParserEngine parserEngine) {
        SQLStatementContext sqlStatementContext = this.parseSQL(databaseName, parserEngine, sql);
        if (sqlStatementContext instanceof CreateTableStatementContext || sqlStatementContext instanceof CommentStatementContext || sqlStatementContext instanceof CreateIndexStatementContext || sqlStatementContext instanceof AlterTableStatementContext) {
            if (((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().isEmpty()) {
                return sql;
            }
            if (((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().isPresent()) {
                return sql;
            }
            TreeMap<SQLSegment, String> replaceMap = new TreeMap<SQLSegment, String>(Comparator.comparing(SQLSegment::getStartIndex));
            TableNameSegment tableNameSegment = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getTablesContext().getSimpleTables().iterator().next()).getTableName();
            replaceMap.put((SQLSegment)tableNameSegment, prefix + tableNameSegment.getIdentifier().getValue());
            return this.doDecorateActualTable(replaceMap, sql);
        }
        return sql;
    }
}

