/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.util;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.Range;

public final class IntervalToRangeIterator
implements Iterator<Range<Long>> {
    private final BigInteger maximum;
    private final BigInteger interval;
    private BigInteger current;

    public IntervalToRangeIterator(long minimum, long maximum, long interval) {
        if (minimum > maximum) {
            throw new IllegalArgumentException("minimum greater than maximum");
        }
        if (interval < 0L) {
            throw new IllegalArgumentException("interval is less than zero");
        }
        this.maximum = BigInteger.valueOf(maximum);
        this.interval = BigInteger.valueOf(interval);
        this.current = BigInteger.valueOf(minimum);
    }

    @Override
    public boolean hasNext() {
        return this.current.compareTo(this.maximum) <= 0;
    }

    @Override
    public Range<Long> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("");
        }
        BigInteger upperLimit = this.min(this.maximum, this.current.add(this.interval));
        Range result = Range.between((Comparable)Long.valueOf(this.current.longValue()), (Comparable)Long.valueOf(upperLimit.longValue()));
        this.current = upperLimit.add(BigInteger.ONE);
        return result;
    }

    private BigInteger min(BigInteger one, BigInteger another) {
        return one.compareTo(another) < 0 ? one : another;
    }
}

