/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.broadcast.rule.BroadcastRule;
import org.apache.shardingsphere.data.pipeline.core.exception.param.PipelineInvalidParameterException;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;
import org.apache.shardingsphere.single.rule.SingleRule;

public final class CDCDataNodeUtils {
    public static Map<String, List<DataNode>> buildDataNodesMap(ShardingSphereDatabase database, Collection<String> tableNames) {
        Optional shardingRule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        Optional singleRule = database.getRuleMetaData().findSingleRule(SingleRule.class);
        Optional broadcastRule = database.getRuleMetaData().findSingleRule(BroadcastRule.class);
        HashMap<String, List<DataNode>> result = new HashMap<String, List<DataNode>>(tableNames.size(), 1.0f);
        for (String each : tableNames) {
            if (singleRule.isPresent() && ((DataNodeRuleAttribute)((SingleRule)singleRule.get()).getAttributes().getAttribute(DataNodeRuleAttribute.class)).getAllDataNodes().containsKey(each)) {
                result.put(each, new ArrayList((Collection)((DataNodeRuleAttribute)((SingleRule)singleRule.get()).getAttributes().getAttribute(DataNodeRuleAttribute.class)).getAllDataNodes().get(each)));
                continue;
            }
            if (shardingRule.isPresent() && ((ShardingRule)shardingRule.get()).findShardingTable(each).isPresent()) {
                ShardingTable shardingTable = ((ShardingRule)shardingRule.get()).getShardingTable(each);
                result.put(each, shardingTable.getActualDataNodes());
                continue;
            }
            if (broadcastRule.isPresent() && ((DataNodeRuleAttribute)((BroadcastRule)broadcastRule.get()).getAttributes().getAttribute(DataNodeRuleAttribute.class)).findFirstActualTable(each).isPresent()) {
                result.put(each, Collections.singletonList((DataNode)((Collection)((DataNodeRuleAttribute)((BroadcastRule)broadcastRule.get()).getAttributes().getAttribute(DataNodeRuleAttribute.class)).getAllDataNodes().get(each)).iterator().next()));
                continue;
            }
            throw new PipelineInvalidParameterException(String.format("Not find actual data nodes of `%s`", each));
        }
        return result;
    }

    @Generated
    private CDCDataNodeUtils() {
    }
}

