/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;

public class GallProjection
extends Projection {
    private static final double YF = 1.7071067811865475;
    private static final double XF = 0.7071067811865476;
    private static final double RYF = 0.585786437626905;
    private static final double RXF = 1.4142135623730951;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.x = 0.7071067811865476 * lplam;
        out.y = 1.7071067811865475 * Math.tan(0.5 * lpphi);
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.x = 1.4142135623730951 * xyx;
        out.y = 2.0 * Math.atan(xyy * 0.585786437626905);
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Gall (Gall Stereographic)";
    }
}

