/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.describe;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLColumnDescription;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLNoDataPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.PostgreSQLRowDescriptionPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.describe.PostgreSQLComDescribePacket;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.exception.postgresql.exception.metadata.ColumnNotFoundException;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.connector.ProxyDatabaseConnectionManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.PortalContext;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.PostgreSQLServerPreparedStatement;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.ReturningSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;

public final class PostgreSQLComDescribeExecutor
implements CommandExecutor {
    private static final String ANONYMOUS_COLUMN_NAME = "?column?";
    private final PortalContext portalContext;
    private final PostgreSQLComDescribePacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() throws SQLException {
        switch (this.packet.getType()) {
            case 'S': {
                return this.describePreparedStatement();
            }
            case 'P': {
                return Collections.singleton(this.portalContext.get(this.packet.getName()).describe());
            }
        }
        throw new UnsupportedSQLOperationException("Unsupported describe type: " + this.packet.getType());
    }

    private List<DatabasePacket> describePreparedStatement() throws SQLException {
        ArrayList<DatabasePacket> result = new ArrayList<DatabasePacket>(2);
        PostgreSQLServerPreparedStatement preparedStatement = (PostgreSQLServerPreparedStatement)this.connectionSession.getServerPreparedStatementRegistry().getPreparedStatement((Object)this.packet.getName());
        result.add((DatabasePacket)preparedStatement.describeParameters());
        Optional<PostgreSQLPacket> rowDescription = preparedStatement.describeRows();
        if (rowDescription.isPresent()) {
            result.add((DatabasePacket)rowDescription.get());
        } else {
            this.tryDescribePreparedStatement(preparedStatement);
            preparedStatement.describeRows().ifPresent(result::add);
        }
        return result;
    }

    private void tryDescribePreparedStatement(PostgreSQLServerPreparedStatement preparedStatement) throws SQLException {
        if (preparedStatement.getSqlStatementContext().getSqlStatement() instanceof InsertStatement) {
            this.describeInsertStatementByDatabaseMetaData(preparedStatement);
        } else {
            this.tryDescribePreparedStatementByJDBC(preparedStatement);
        }
    }

    private void describeInsertStatementByDatabaseMetaData(PostgreSQLServerPreparedStatement preparedStatement) {
        InsertStatement insertStatement = (InsertStatement)preparedStatement.getSqlStatementContext().getSqlStatement();
        Collection<Integer> unspecifiedTypeParameterIndexes = this.getUnspecifiedTypeParameterIndexes(preparedStatement);
        Optional returningSegment = insertStatement.getReturningSegment();
        if (insertStatement.getParameterMarkerSegments().isEmpty() && unspecifiedTypeParameterIndexes.isEmpty() && !returningSegment.isPresent()) {
            return;
        }
        String logicTableName = insertStatement.getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        ShardingSphereTable table = this.getTableFromMetaData(this.connectionSession.getUsedDatabaseName(), insertStatement, logicTableName);
        List<String> columnNamesOfInsert = this.getColumnNamesOfInsertStatement(insertStatement, table);
        preparedStatement.setRowDescription(returningSegment.map(returning -> this.describeReturning((ReturningSegment)returning, table)).orElseGet(PostgreSQLNoDataPacket::getInstance));
        int parameterMarkerIndex = 0;
        for (InsertValuesSegment each : insertStatement.getValues()) {
            ListIterator listIterator = each.getValues().listIterator();
            int columnIndex = listIterator.nextIndex();
            while (listIterator.hasNext()) {
                ExpressionSegment value = (ExpressionSegment)listIterator.next();
                if (value instanceof ParameterMarkerExpressionSegment) {
                    if (!unspecifiedTypeParameterIndexes.contains(parameterMarkerIndex)) {
                        ++parameterMarkerIndex;
                    } else {
                        String columnName = columnNamesOfInsert.get(columnIndex);
                        ShardingSphereColumn column = table.getColumn(columnName);
                        ShardingSpherePreconditions.checkNotNull((Object)column, () -> new ColumnNotFoundException(logicTableName, columnName));
                        preparedStatement.getParameterTypes().set(parameterMarkerIndex++, PostgreSQLColumnType.valueOfJDBCType((int)column.getDataType()));
                    }
                }
                columnIndex = listIterator.nextIndex();
            }
        }
    }

    private Collection<Integer> getUnspecifiedTypeParameterIndexes(PostgreSQLServerPreparedStatement preparedStatement) {
        HashSet<Integer> result = new HashSet<Integer>();
        ListIterator<PostgreSQLColumnType> parameterTypesListIterator = preparedStatement.getParameterTypes().listIterator();
        int index = parameterTypesListIterator.nextIndex();
        while (parameterTypesListIterator.hasNext()) {
            if (PostgreSQLColumnType.UNSPECIFIED == parameterTypesListIterator.next()) {
                result.add(index);
            }
            index = parameterTypesListIterator.nextIndex();
        }
        return result;
    }

    private ShardingSphereTable getTableFromMetaData(String databaseName, InsertStatement insertStatement, String logicTableName) {
        ShardingSphereDatabase database = ProxyContext.getInstance().getContextManager().getDatabase(databaseName);
        String schemaName = insertStatement.getTable().flatMap(SimpleTableSegment::getOwner).map(optional -> optional.getIdentifier().getValue()).orElseGet(() -> new DatabaseTypeRegistry(database.getProtocolType()).getDefaultSchemaName(databaseName));
        return database.getSchema(schemaName).getTable(logicTableName);
    }

    private List<String> getColumnNamesOfInsertStatement(InsertStatement insertStatement, ShardingSphereTable table) {
        return insertStatement.getColumns().isEmpty() ? table.getColumnNames() : insertStatement.getColumns().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toList());
    }

    private PostgreSQLRowDescriptionPacket describeReturning(ReturningSegment returningSegment, ShardingSphereTable table) {
        LinkedList<PostgreSQLColumnDescription> result = new LinkedList<PostgreSQLColumnDescription>();
        for (ProjectionSegment each : returningSegment.getProjections().getProjections()) {
            if (each instanceof ShorthandProjectionSegment) {
                table.getColumnValues().stream().map(column -> new PostgreSQLColumnDescription(column.getName(), 0, column.getDataType(), this.estimateColumnLength(column.getDataType()), "")).forEach(result::add);
            }
            if (each instanceof ColumnProjectionSegment) {
                ColumnProjectionSegment segment = (ColumnProjectionSegment)each;
                String columnName = segment.getColumn().getIdentifier().getValue();
                ShardingSphereColumn column2 = table.containsColumn(columnName) ? table.getColumn(columnName) : this.generateDefaultColumn(segment);
                String alias = segment.getAliasName().orElseGet(() -> ((ShardingSphereColumn)column2).getName());
                result.add(new PostgreSQLColumnDescription(alias, 0, column2.getDataType(), this.estimateColumnLength(column2.getDataType()), ""));
            }
            if (!(each instanceof ExpressionProjectionSegment)) continue;
            result.add(this.convertExpressionToDescription((ExpressionProjectionSegment)each));
        }
        return new PostgreSQLRowDescriptionPacket(result);
    }

    private ShardingSphereColumn generateDefaultColumn(ColumnProjectionSegment segment) {
        return new ShardingSphereColumn(segment.getColumn().getIdentifier().getValue(), 12, false, false, false, true, false, false);
    }

    private PostgreSQLColumnDescription convertExpressionToDescription(ExpressionProjectionSegment expressionProjectionSegment) {
        ExpressionSegment expressionSegment = expressionProjectionSegment.getExpr();
        String columnName = expressionProjectionSegment.getAliasName().orElse(ANONYMOUS_COLUMN_NAME);
        if (expressionSegment instanceof LiteralExpressionSegment) {
            Object value = ((LiteralExpressionSegment)expressionSegment).getLiterals();
            if (value instanceof String) {
                return new PostgreSQLColumnDescription(columnName, 0, 12, this.estimateColumnLength(12), "");
            }
            if (value instanceof Integer) {
                return new PostgreSQLColumnDescription(columnName, 0, 4, this.estimateColumnLength(4), "");
            }
            if (value instanceof Long) {
                return new PostgreSQLColumnDescription(columnName, 0, -5, this.estimateColumnLength(-5), "");
            }
            if (value instanceof Number) {
                return new PostgreSQLColumnDescription(columnName, 0, 2, this.estimateColumnLength(2), "");
            }
        }
        return new PostgreSQLColumnDescription(columnName, 0, 12, this.estimateColumnLength(12), "");
    }

    private int estimateColumnLength(int jdbcType) {
        switch (jdbcType) {
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
        }
        return -1;
    }

    private void tryDescribePreparedStatementByJDBC(PostgreSQLServerPreparedStatement logicPreparedStatement) throws SQLException {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        String databaseName = this.connectionSession.getUsedDatabaseName();
        SQLStatementContext sqlStatementContext = new SQLBindEngine(metaDataContexts.getMetaData(), this.connectionSession.getCurrentDatabaseName(), logicPreparedStatement.getHintValueContext()).bind(logicPreparedStatement.getSqlStatementContext().getSqlStatement(), Collections.emptyList());
        QueryContext queryContext = new QueryContext(sqlStatementContext, logicPreparedStatement.getSql(), Collections.emptyList(), logicPreparedStatement.getHintValueContext(), this.connectionSession.getConnectionContext(), metaDataContexts.getMetaData());
        ExecutionContext executionContext = new KernelProcessor().generateExecutionContext(queryContext, metaDataContexts.getMetaData().getGlobalRuleMetaData(), metaDataContexts.getMetaData().getProps(), this.connectionSession.getConnectionContext());
        ExecutionUnit executionUnitSample = (ExecutionUnit)executionContext.getExecutionUnits().iterator().next();
        ProxyDatabaseConnectionManager databaseConnectionManager = this.connectionSession.getDatabaseConnectionManager();
        Connection connection = (Connection)databaseConnectionManager.getConnections(databaseName, executionUnitSample.getDataSourceName(), 0, 1, ConnectionMode.CONNECTION_STRICTLY).iterator().next();
        try (PreparedStatement actualPreparedStatement = connection.prepareStatement(executionUnitSample.getSqlUnit().getSql());){
            this.populateParameterTypes(logicPreparedStatement, actualPreparedStatement);
            this.populateColumnTypes(logicPreparedStatement, actualPreparedStatement);
        }
    }

    private void populateParameterTypes(PostgreSQLServerPreparedStatement logicPreparedStatement, PreparedStatement actualPreparedStatement) throws SQLException {
        if (0 == logicPreparedStatement.getSqlStatementContext().getSqlStatement().getParameterCount() || logicPreparedStatement.getParameterTypes().stream().noneMatch(each -> PostgreSQLColumnType.UNSPECIFIED == each)) {
            return;
        }
        ParameterMetaData parameterMetaData = actualPreparedStatement.getParameterMetaData();
        for (int i = 0; i < logicPreparedStatement.getSqlStatementContext().getSqlStatement().getParameterCount(); ++i) {
            if (PostgreSQLColumnType.UNSPECIFIED != logicPreparedStatement.getParameterTypes().get(i)) continue;
            logicPreparedStatement.getParameterTypes().set(i, PostgreSQLColumnType.valueOfJDBCType((int)parameterMetaData.getParameterType(i + 1), (String)parameterMetaData.getParameterTypeName(i + 1)));
        }
    }

    private void populateColumnTypes(PostgreSQLServerPreparedStatement logicPreparedStatement, PreparedStatement actualPreparedStatement) throws SQLException {
        if (logicPreparedStatement.describeRows().isPresent()) {
            return;
        }
        ResultSetMetaData resultSetMetaData = actualPreparedStatement.getMetaData();
        if (null == resultSetMetaData) {
            logicPreparedStatement.setRowDescription((PostgreSQLPacket)PostgreSQLNoDataPacket.getInstance());
            return;
        }
        ArrayList<PostgreSQLColumnDescription> columnDescriptions = new ArrayList<PostgreSQLColumnDescription>(resultSetMetaData.getColumnCount());
        for (int columnIndex = 1; columnIndex <= resultSetMetaData.getColumnCount(); ++columnIndex) {
            String columnName = resultSetMetaData.getColumnName(columnIndex);
            int columnType = resultSetMetaData.getColumnType(columnIndex);
            int columnLength = resultSetMetaData.getColumnDisplaySize(columnIndex);
            String columnTypeName = resultSetMetaData.getColumnTypeName(columnIndex);
            columnDescriptions.add(new PostgreSQLColumnDescription(columnName, columnIndex, columnType, columnLength, columnTypeName));
        }
        logicPreparedStatement.setRowDescription((PostgreSQLPacket)new PostgreSQLRowDescriptionPacket(columnDescriptions));
    }

    @Generated
    public PostgreSQLComDescribeExecutor(PortalContext portalContext, PostgreSQLComDescribePacket packet, ConnectionSession connectionSession) {
        this.portalContext = portalContext;
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

