/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.parse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLColumnType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.parse.PostgreSQLComParsePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.parse.PostgreSQLParseCompletePacket;
import org.apache.shardingsphere.distsql.statement.DistSQLStatement;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.distsql.DistSQLStatementContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.session.ServerPreparedStatement;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.postgresql.command.query.extended.PostgreSQLServerPreparedStatement;
import org.apache.shardingsphere.sql.parser.statement.core.enums.ParameterMarkerType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParameterMarkerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.AbstractSQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DMLStatement;

public final class PostgreSQLComParseExecutor
implements CommandExecutor {
    private final PostgreSQLComParsePacket packet;
    private final ConnectionSession connectionSession;

    public Collection<DatabasePacket> execute() {
        String sql;
        SQLParserEngine sqlParserEngine = this.createShardingSphereSQLParserEngine(this.connectionSession.getUsedDatabaseName());
        SQLStatement sqlStatement = sqlParserEngine.parse(sql = this.packet.getSQL(), true);
        String escapedSql = this.escape(sqlStatement, sql);
        if (!escapedSql.equalsIgnoreCase(sql)) {
            sqlStatement = sqlParserEngine.parse(escapedSql, true);
            sql = escapedSql;
        }
        ArrayList<Integer> actualParameterMarkerIndexes = new ArrayList<Integer>();
        if (sqlStatement.getParameterCount() > 0) {
            ArrayList<ParameterMarkerSegment> parameterMarkerSegments = new ArrayList<ParameterMarkerSegment>(((AbstractSQLStatement)sqlStatement).getParameterMarkerSegments());
            for (ParameterMarkerSegment each : parameterMarkerSegments) {
                actualParameterMarkerIndexes.add(each.getParameterIndex());
            }
            sql = this.convertSQLToJDBCStyle(parameterMarkerSegments, sql);
            sqlStatement = sqlParserEngine.parse(sql, true);
        }
        List<PostgreSQLColumnType> paddedColumnTypes = this.paddingColumnTypes(sqlStatement.getParameterCount(), this.packet.readParameterTypes());
        DistSQLStatementContext sqlStatementContext = sqlStatement instanceof DistSQLStatement ? new DistSQLStatementContext((DistSQLStatement)sqlStatement) : new SQLBindEngine(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(), this.connectionSession.getCurrentDatabaseName(), this.packet.getHintValueContext()).bind(sqlStatement, Collections.emptyList());
        PostgreSQLServerPreparedStatement serverPreparedStatement = new PostgreSQLServerPreparedStatement(sql, (SQLStatementContext)sqlStatementContext, this.packet.getHintValueContext(), paddedColumnTypes, actualParameterMarkerIndexes);
        this.connectionSession.getServerPreparedStatementRegistry().addPreparedStatement((Object)this.packet.getStatementId(), (ServerPreparedStatement)serverPreparedStatement);
        return Collections.singleton(PostgreSQLParseCompletePacket.getInstance());
    }

    private SQLParserEngine createShardingSphereSQLParserEngine(String databaseName) {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        SQLParserRule sqlParserRule = (SQLParserRule)metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        return sqlParserRule.getSQLParserEngine(metaDataContexts.getMetaData().getDatabase(databaseName).getProtocolType());
    }

    private String escape(SQLStatement sqlStatement, String sql) {
        if (sqlStatement instanceof DMLStatement) {
            return sql.replace("?", "??");
        }
        return sql;
    }

    private String convertSQLToJDBCStyle(List<ParameterMarkerSegment> parameterMarkerSegments, String sql) {
        parameterMarkerSegments.sort(Comparator.comparingInt(SQLSegment::getStopIndex));
        StringBuilder result = new StringBuilder(sql);
        for (int i = parameterMarkerSegments.size() - 1; i >= 0; --i) {
            ParameterMarkerSegment each = parameterMarkerSegments.get(i);
            result.replace(each.getStartIndex(), each.getStopIndex() + 1, ParameterMarkerType.QUESTION.getMarker());
        }
        return result.toString();
    }

    private List<PostgreSQLColumnType> paddingColumnTypes(int parameterCount, List<PostgreSQLColumnType> specifiedColumnTypes) {
        if (parameterCount == specifiedColumnTypes.size()) {
            return specifiedColumnTypes;
        }
        ArrayList<PostgreSQLColumnType> result = new ArrayList<PostgreSQLColumnType>(parameterCount);
        result.addAll(specifiedColumnTypes);
        int unspecifiedCount = parameterCount - specifiedColumnTypes.size();
        for (int i = 0; i < unspecifiedCount; ++i) {
            result.add(PostgreSQLColumnType.UNSPECIFIED);
        }
        return result;
    }

    @Generated
    public PostgreSQLComParseExecutor(PostgreSQLComParsePacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

