/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.err;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLErrorResponsePacket;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.external.sql.sqlstate.XOpenSQLState;
import org.apache.shardingsphere.infra.exception.dialect.SQLExceptionTransformEngine;
import org.apache.shardingsphere.infra.exception.postgresql.exception.PostgreSQLException;
import org.apache.shardingsphere.infra.exception.postgresql.vendor.PostgreSQLVendorError;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.postgresql.util.PSQLException;
import org.postgresql.util.ServerErrorMessage;

public final class PostgreSQLErrorPacketFactory {
    private static final DatabaseType DATABASE_TYPE = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"PostgreSQL");

    public static PostgreSQLErrorResponsePacket newInstance(Exception cause) {
        Optional<ServerErrorMessage> serverErrorMessage = PostgreSQLErrorPacketFactory.findServerErrorMessage(cause);
        return serverErrorMessage.map(PostgreSQLErrorPacketFactory::createErrorResponsePacket).orElseGet(() -> PostgreSQLErrorPacketFactory.createErrorResponsePacket(SQLExceptionTransformEngine.toSQLException((Exception)cause, (DatabaseType)DATABASE_TYPE)));
    }

    private static Optional<ServerErrorMessage> findServerErrorMessage(Exception cause) {
        return cause instanceof PSQLException ? Optional.ofNullable(((PSQLException)cause).getServerErrorMessage()) : Optional.empty();
    }

    private static PostgreSQLErrorResponsePacket createErrorResponsePacket(ServerErrorMessage serverErrorMessage) {
        return PostgreSQLErrorResponsePacket.newBuilder((String)serverErrorMessage.getSeverity(), (String)serverErrorMessage.getSQLState(), (String)serverErrorMessage.getMessage()).detail(serverErrorMessage.getDetail()).hint(serverErrorMessage.getHint()).position(serverErrorMessage.getPosition()).internalQueryAndInternalPosition(serverErrorMessage.getInternalQuery(), serverErrorMessage.getInternalPosition()).where(serverErrorMessage.getWhere()).schemaName(serverErrorMessage.getSchema()).tableName(serverErrorMessage.getTable()).columnName(serverErrorMessage.getColumn()).dataTypeName(serverErrorMessage.getDatatype()).constraintName(serverErrorMessage.getConstraint()).file(serverErrorMessage.getFile()).line(serverErrorMessage.getLine()).routine(serverErrorMessage.getRoutine()).build();
    }

    private static PostgreSQLErrorResponsePacket createErrorResponsePacket(SQLException cause) {
        if (cause instanceof PostgreSQLException && null != ((PostgreSQLException)cause).getServerErrorMessage()) {
            return PostgreSQLErrorPacketFactory.createErrorResponsePacket(((PostgreSQLException)cause).getServerErrorMessage());
        }
        if (cause instanceof PSQLException && null != ((PSQLException)cause).getServerErrorMessage()) {
            return PostgreSQLErrorPacketFactory.createErrorResponsePacket(((PSQLException)cause).getServerErrorMessage());
        }
        String sqlState = Strings.isNullOrEmpty((String)cause.getSQLState()) || XOpenSQLState.GENERAL_ERROR.getValue().equals(cause.getSQLState()) ? PostgreSQLVendorError.SYSTEM_ERROR.getSqlState().getValue() : cause.getSQLState();
        String message = Strings.isNullOrEmpty((String)cause.getMessage()) ? cause.toString() : cause.getMessage();
        return PostgreSQLErrorResponsePacket.newBuilder((String)"ERROR", (String)sqlState, (String)message).build();
    }

    private static PostgreSQLErrorResponsePacket createErrorResponsePacket(PostgreSQLException.ServerErrorMessage serverErrorMessage) {
        return PostgreSQLErrorResponsePacket.newBuilder((String)serverErrorMessage.getSeverity(), (String)serverErrorMessage.getSqlState(), (String)serverErrorMessage.getMessage()).build();
    }

    @Generated
    private PostgreSQLErrorPacketFactory() {
    }
}

