/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.sysvar;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.constant.DatabaseProtocolServerInfo;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.mysql.exception.ErrorGlobalVariableException;
import org.apache.shardingsphere.infra.exception.mysql.exception.ErrorLocalVariableException;
import org.apache.shardingsphere.infra.exception.mysql.exception.IncorrectGlobalLocalVariableException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.sysvar.MySQLSystemVariableValueProvider;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.sysvar.Scope;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.sysvar.provider.TransactionIsolationValueProvider;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.sysvar.provider.TransactionReadOnlyValueProvider;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.sysvar.provider.VersionValueProvider;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public enum MySQLSystemVariable {
    ACTIVATE_ALL_ROLES_ON_LOGIN(1, "0"),
    ADMIN_ADDRESS(1025, ""),
    ADMIN_PORT(1025, "33062"),
    ADMIN_SSL_CA(65537, ""),
    ADMIN_SSL_CAPATH(65537, ""),
    ADMIN_SSL_CERT(65537, ""),
    ADMIN_SSL_CIPHER(65537, ""),
    ADMIN_SSL_CRL(65537, ""),
    ADMIN_SSL_CRLPATH(65537, ""),
    ADMIN_SSL_KEY(65537, ""),
    ADMIN_TLS_CIPHERSUITES(65537, ""),
    ADMIN_TLS_VERSION(65537, "TLSv1.2,TLSv1.3"),
    AUTHENTICATION_POLICY(1, "*,,"),
    AUTO_GENERATE_CERTS(1025, "1"),
    AUTO_INCREMENT_INCREMENT(32770, "1"),
    AUTO_INCREMENT_OFFSET(32770, "1"),
    AUTOCOMMIT(2, "1"),
    AUTOMATIC_SP_PRIVILEGES(1, "1"),
    AVOID_TEMPORAL_UPGRADE(1, "0"),
    BACK_LOG(1025, "0"),
    BASEDIR(1025, ""),
    BIG_TABLES(32770, "0"),
    BIND_ADDRESS(1025, "*"),
    BINLOG_CACHE_SIZE(1, "32768"),
    BINLOG_CHECKSUM(65537, "CRC32"),
    BINLOG_DIRECT_NON_TRANSACTIONAL_UPDATES(2, "0"),
    BINLOG_ENCRYPTION(65537, "0"),
    BINLOG_ERROR_ACTION(1, "ABORT_SERVER"),
    BINLOG_EXPIRE_LOGS_AUTO_PURGE(1, "1"),
    BINLOG_EXPIRE_LOGS_SECONDS(1, "2592000"),
    BINLOG_FORMAT(2, "ROW"),
    BINLOG_GROUP_COMMIT_SYNC_DELAY(1, "0"),
    BINLOG_GROUP_COMMIT_SYNC_NO_DELAY_COUNT(1, "0"),
    BINLOG_GTID_SIMPLE_RECOVERY(1025, "1"),
    BINLOG_MAX_FLUSH_QUEUE_TIME(1, "0"),
    BINLOG_ORDER_COMMITS(1, "1"),
    BINLOG_ROTATE_ENCRYPTION_MASTER_KEY_AT_STARTUP(1025, "0"),
    BINLOG_ROW_EVENT_MAX_SIZE(1025, "8192"),
    BINLOG_ROW_IMAGE(2, "FULL"),
    BINLOG_ROW_METADATA(1, "MINIMAL"),
    BINLOG_ROW_VALUE_OPTIONS(2, ""),
    BINLOG_ROWS_QUERY_LOG_EVENTS(2, "0"),
    BINLOG_STMT_CACHE_SIZE(1, "32768"),
    BINLOG_TRANSACTION_COMPRESSION(2, "0"),
    BINLOG_TRANSACTION_COMPRESSION_LEVEL_ZSTD(2, "3"),
    BINLOG_TRANSACTION_DEPENDENCY_HISTORY_SIZE(1, "25000"),
    BINLOG_TRANSACTION_DEPENDENCY_TRACKING(1, "COMMIT_ORDER"),
    BLOCK_ENCRYPTION_MODE(2, "aes-128-ecb"),
    BUILD_ID(1025, ""),
    BULK_INSERT_BUFFER_SIZE(32770, "8388608"),
    CHARACTER_SET_CLIENT(2, "utf8mb4"),
    CHARACTER_SET_CONNECTION(2, "utf8mb4"),
    CHARACTER_SET_DATABASE(2, "utf8mb4"),
    CHARACTER_SET_FILESYSTEM(2, "binary"),
    CHARACTER_SET_RESULTS(2, "utf8mb4"),
    CHARACTER_SET_SERVER(2, "utf8mb4"),
    CHARACTER_SET_SYSTEM(1025, "utf8mb4"),
    CHARACTER_SETS_DIR(1025, ""),
    CHECK_PROXY_USERS(1, "0"),
    COLLATION_CONNECTION(2, "utf8mb4_unicode_ci"),
    COLLATION_DATABASE(2, "utf8mb4_unicode_ci"),
    COLLATION_SERVER(2, "utf8mb4_unicode_ci"),
    COMPLETION_TYPE(2, "NO_CHAIN"),
    CONCURRENT_INSERT(1, "AUTO"),
    CONNECT_TIMEOUT(1, "10"),
    CONNECTION_MEMORY_CHUNK_SIZE(2, "8912"),
    CONNECTION_MEMORY_LIMIT(2, "18446744073709551615"),
    CORE_FILE(1025, "0"),
    CREATE_ADMIN_LISTENER_THREAD(1025, "0"),
    CTE_MAX_RECURSION_DEPTH(32770, "1000"),
    DATADIR(1025, ""),
    DEBUG_SENSITIVE_SESSION_STRING(131074, ""),
    DEFAULT_AUTHENTICATION_PLUGIN(1025, "caching_sha2_password"),
    DEFAULT_COLLATION_FOR_UTF8MB4(2, "utf8mb4_unicode_ci"),
    DEFAULT_PASSWORD_LIFETIME(1, "0"),
    DEFAULT_STORAGE_ENGINE(2, ""),
    DEFAULT_TABLE_ENCRYPTION(32770, "0"),
    DEFAULT_TMP_STORAGE_ENGINE(32770, ""),
    DEFAULT_WEEK_FORMAT(2, "0"),
    DELAY_KEY_WRITE(1, "ON"),
    DELAYED_INSERT_LIMIT(1, "100"),
    DELAYED_INSERT_TIMEOUT(1, "300"),
    DELAYED_QUEUE_SIZE(1, "1000"),
    DISABLED_STORAGE_ENGINES(1025, ""),
    DISCONNECT_ON_EXPIRED_PASSWORD(1025, "1"),
    DIV_PRECISION_INCREMENT(32770, "4"),
    END_MARKERS_IN_JSON(32770, "0"),
    ENFORCE_GTID_CONSISTENCY(65537, "FALSE"),
    EQ_RANGE_INDEX_DIVE_LIMIT(32770, "200"),
    ERROR_COUNT(1028, "0"),
    EVENT_SCHEDULER(1, "ON"),
    EXPIRE_LOGS_DAYS(1, "0"),
    EXPLICIT_DEFAULTS_FOR_TIMESTAMP(2, "1"),
    EXTERNAL_USER(1028, ""),
    FLUSH(1, "0"),
    FLUSH_TIME(1, "0"),
    FOREIGN_KEY_CHECKS(32770, "1"),
    FT_BOOLEAN_SYNTAX(1, "+ -><()~*:\"\"&|"),
    FT_MAX_WORD_LEN(1025, "84"),
    FT_MIN_WORD_LEN(1025, "4"),
    FT_QUERY_EXPANSION_LIMIT(1025, "20"),
    FT_STOPWORD_FILE(1025, ""),
    GENERAL_LOG(1, "0"),
    GENERAL_LOG_FILE(1, ""),
    GENERATED_RANDOM_PASSWORD_LENGTH(2, "20"),
    GLOBAL_CONNECTION_MEMORY_LIMIT(1, "18446744073709551615"),
    GLOBAL_CONNECTION_MEMORY_TRACKING(2, "0"),
    GROUP_CONCAT_MAX_LEN(32770, "1024"),
    GTID_EXECUTED_COMPRESSION_PERIOD(1, "0"),
    HAVE_SSL(1025, "NO"),
    HISTOGRAM_GENERATION_MAX_MEM_SIZE(2, "20000000"),
    HOST_CACHE_SIZE(1, "128"),
    HOSTNAME(1025, ""),
    IDENTITY(4, "0"),
    IMMEDIATE_SERVER_VERSION(4, "999999"),
    INFORMATION_SCHEMA_STATS_EXPIRY(2, "86400"),
    INIT_CONNECT(1, ""),
    INIT_FILE(1025, ""),
    INIT_REPLICA(1, ""),
    INIT_SLAVE(1, ""),
    INSERT_ID(32772, "0"),
    INTERACTIVE_TIMEOUT(2, "28800"),
    JOIN_BUFFER_SIZE(32770, "262144"),
    KEEP_FILES_ON_CREATE(2, "0"),
    KEYRING_OPERATIONS(1, "1"),
    LARGE_FILES_SUPPORT(1025, "1"),
    LARGE_PAGE_SIZE(1025, "0"),
    LARGE_PAGES(1025, "0"),
    LAST_INSERT_ID(4, "0"),
    LC_MESSAGES(2, ""),
    LC_MESSAGES_DIR(1025, ""),
    LC_TIME_NAMES(2, ""),
    LICENSE(1025, "GPL"),
    LOCAL_INFILE(1, "0"),
    LOCK_WAIT_TIMEOUT(32770, "31536000"),
    LOCKED_IN_MEMORY(1025, "0"),
    LOG_BIN(1025, "1"),
    LOG_BIN_BASENAME(1025, ""),
    LOG_BIN_INDEX(1025, ""),
    LOG_BIN_TRUST_FUNCTION_CREATORS(1, "0"),
    LOG_BIN_USE_V1_ROW_EVENTS(1, "0"),
    LOG_ERROR(1025, "0"),
    LOG_ERROR_SERVICES(65537, "log_filter_internal; log_sink_internal"),
    LOG_ERROR_SUPPRESSION_LIST(65537, ""),
    LOG_ERROR_VERBOSITY(65537, "2"),
    LOG_QUERIES_NOT_USING_INDEXES(1, "0"),
    LOG_RAW(1, "0"),
    LOG_REPLICA_UPDATES(1025, "1"),
    LOG_SLAVE_UPDATES(1025, "1"),
    LOG_SLOW_ADMIN_STATEMENTS(1, "0"),
    LOG_SLOW_EXTRA(1, "0"),
    LOG_SLOW_REPLICA_STATEMENTS(1, "0"),
    LOG_SLOW_SLAVE_STATEMENTS(1, "0"),
    LOG_STATEMENTS_UNSAFE_FOR_BINLOG(1, "1"),
    LOG_THROTTLE_QUERIES_NOT_USING_INDEXES(1, "0"),
    LONG_QUERY_TIME(2, "4.62182e+18"),
    LOW_PRIORITY_UPDATES(2, "0"),
    LOWER_CASE_FILE_SYSTEM(1025, "0"),
    LOWER_CASE_TABLE_NAMES(1025, "0"),
    MANDATORY_ROLES(1, ""),
    MASTER_VERIFY_CHECKSUM(1, "0"),
    MAX_ALLOWED_PACKET(2, "67108864"),
    MAX_BINLOG_CACHE_SIZE(1, "18446744073709547520"),
    MAX_BINLOG_SIZE(1, "1073741824"),
    MAX_BINLOG_STMT_CACHE_SIZE(1, "18446744073709547520"),
    MAX_CONNECT_ERRORS(1, "100"),
    MAX_CONNECTIONS(1, "151"),
    MAX_DELAYED_THREADS(2, "20"),
    MAX_DIGEST_LENGTH(1025, "1024"),
    MAX_ERROR_COUNT(32770, "1024"),
    MAX_EXECUTION_TIME(32770, "0"),
    MAX_HEAP_TABLE_SIZE(32770, "16777216"),
    MAX_INSERT_DELAYED_THREADS(2, "20"),
    MAX_JOIN_SIZE(32770, "18446744073709551615"),
    MAX_LENGTH_FOR_SORT_DATA(32770, "4096"),
    MAX_POINTS_IN_GEOMETRY(32770, "65536"),
    MAX_PREPARED_STMT_COUNT(1, "16382"),
    MAX_RELAY_LOG_SIZE(1, "0"),
    MAX_SEEKS_FOR_KEY(32770, "18446744073709551615"),
    MAX_SORT_LENGTH(32770, "1024"),
    MAX_SP_RECURSION_DEPTH(2, "0"),
    MAX_USER_CONNECTIONS(2, "0"),
    MAX_WRITE_LOCK_COUNT(1, "18446744073709551615"),
    MIN_EXAMINED_ROW_LIMIT(2, "0"),
    MYSQL_NATIVE_PASSWORD_PROXY_USERS(1, "0"),
    NET_BUFFER_LENGTH(2, "16384"),
    NET_READ_TIMEOUT(2, "30"),
    NET_RETRY_COUNT(2, "10"),
    NET_WRITE_TIMEOUT(2, "60"),
    NEW(2, "0"),
    OFFLINE_MODE(1, "0"),
    OLD(1025, "0"),
    OLD_ALTER_TABLE(2, "0"),
    OPEN_FILES_LIMIT(1025, "0"),
    OPTIMIZER_MAX_SUBGRAPH_PAIRS(32770, "100000"),
    OPTIMIZER_PRUNE_LEVEL(32770, "1"),
    OPTIMIZER_SEARCH_DEPTH(32770, "62"),
    OPTIMIZER_TRACE_LIMIT(2, "1"),
    OPTIMIZER_TRACE_MAX_MEM_SIZE(2, "1048576"),
    OPTIMIZER_TRACE_OFFSET(2, "-1"),
    ORIGINAL_COMMIT_TIMESTAMP(4, "36028797018963968"),
    ORIGINAL_SERVER_VERSION(4, "999999"),
    PARSER_MAX_MEM_SIZE(2, "18446744073709551615"),
    PARTIAL_REVOKES(1, "0"),
    PASSWORD_HISTORY(1, "0"),
    PASSWORD_REQUIRE_CURRENT(1, "0"),
    PASSWORD_REUSE_INTERVAL(1, "0"),
    PERFORMANCE_SCHEMA(1025, "1"),
    PERFORMANCE_SCHEMA_ACCOUNTS_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_STAGES_CURRENT(5121, "0"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_STAGES_HISTORY(5121, "0"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_STAGES_HISTORY_LONG(5121, "0"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_STATEMENTS_CPU(5121, "0"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_STATEMENTS_CURRENT(5121, "1"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_STATEMENTS_HISTORY(5121, "1"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_STATEMENTS_HISTORY_LONG(5121, "0"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_TRANSACTIONS_CURRENT(5121, "1"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_TRANSACTIONS_HISTORY(5121, "1"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_TRANSACTIONS_HISTORY_LONG(5121, "0"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_WAITS_CURRENT(5121, "0"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_WAITS_HISTORY(5121, "0"),
    PERFORMANCE_SCHEMA_CONSUMER_EVENTS_WAITS_HISTORY_LONG(5121, "0"),
    PERFORMANCE_SCHEMA_CONSUMER_GLOBAL_INSTRUMENTATION(5121, "1"),
    PERFORMANCE_SCHEMA_CONSUMER_STATEMENTS_DIGEST(5121, "1"),
    PERFORMANCE_SCHEMA_CONSUMER_THREAD_INSTRUMENTATION(5121, "1"),
    PERFORMANCE_SCHEMA_DIGESTS_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_ERROR_SIZE(1025, "5242"),
    PERFORMANCE_SCHEMA_EVENTS_STAGES_HISTORY_LONG_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_EVENTS_STAGES_HISTORY_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_EVENTS_STATEMENTS_HISTORY_LONG_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_EVENTS_STATEMENTS_HISTORY_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_EVENTS_TRANSACTIONS_HISTORY_LONG_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_EVENTS_TRANSACTIONS_HISTORY_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_EVENTS_WAITS_HISTORY_LONG_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_EVENTS_WAITS_HISTORY_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_HOSTS_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_INSTRUMENT(5121, ""),
    PERFORMANCE_SCHEMA_MAX_COND_CLASSES(1025, "150"),
    PERFORMANCE_SCHEMA_MAX_COND_INSTANCES(1025, "-1"),
    PERFORMANCE_SCHEMA_MAX_DIGEST_LENGTH(1025, "1024"),
    PERFORMANCE_SCHEMA_MAX_DIGEST_SAMPLE_AGE(1, "60"),
    PERFORMANCE_SCHEMA_MAX_FILE_CLASSES(1025, "80"),
    PERFORMANCE_SCHEMA_MAX_FILE_HANDLES(1025, "32768"),
    PERFORMANCE_SCHEMA_MAX_FILE_INSTANCES(1025, "-1"),
    PERFORMANCE_SCHEMA_MAX_INDEX_STAT(1025, "-1"),
    PERFORMANCE_SCHEMA_MAX_MEMORY_CLASSES(1025, "450"),
    PERFORMANCE_SCHEMA_MAX_METADATA_LOCKS(1025, "-1"),
    PERFORMANCE_SCHEMA_MAX_MUTEX_CLASSES(1025, "350"),
    PERFORMANCE_SCHEMA_MAX_MUTEX_INSTANCES(1025, "-1"),
    PERFORMANCE_SCHEMA_MAX_PREPARED_STATEMENTS_INSTANCES(1025, "-1"),
    PERFORMANCE_SCHEMA_MAX_PROGRAM_INSTANCES(1025, "-1"),
    PERFORMANCE_SCHEMA_MAX_RWLOCK_CLASSES(1025, "60"),
    PERFORMANCE_SCHEMA_MAX_RWLOCK_INSTANCES(1025, "-1"),
    PERFORMANCE_SCHEMA_MAX_SOCKET_CLASSES(1025, "10"),
    PERFORMANCE_SCHEMA_MAX_SOCKET_INSTANCES(1025, "-1"),
    PERFORMANCE_SCHEMA_MAX_SQL_TEXT_LENGTH(1025, "1024"),
    PERFORMANCE_SCHEMA_MAX_STAGE_CLASSES(1025, "175"),
    PERFORMANCE_SCHEMA_MAX_STATEMENT_CLASSES(1025, "219"),
    PERFORMANCE_SCHEMA_MAX_STATEMENT_STACK(1025, "10"),
    PERFORMANCE_SCHEMA_MAX_TABLE_HANDLES(1025, "-1"),
    PERFORMANCE_SCHEMA_MAX_TABLE_INSTANCES(1025, "-1"),
    PERFORMANCE_SCHEMA_MAX_TABLE_LOCK_STAT(1025, "-1"),
    PERFORMANCE_SCHEMA_MAX_THREAD_CLASSES(1025, "100"),
    PERFORMANCE_SCHEMA_MAX_THREAD_INSTANCES(1025, "-1"),
    PERFORMANCE_SCHEMA_SESSION_CONNECT_ATTRS_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_SETUP_ACTORS_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_SETUP_OBJECTS_SIZE(1025, "-1"),
    PERFORMANCE_SCHEMA_SHOW_PROCESSLIST(1, "0"),
    PERFORMANCE_SCHEMA_USERS_SIZE(1025, "-1"),
    PERSIST_ONLY_ADMIN_X509_SUBJECT(1025, ""),
    PERSIST_SENSITIVE_VARIABLES_IN_PLAINTEXT(1025, "1"),
    PERSISTED_GLOBALS_LOAD(1025, "1"),
    PID_FILE(1025, ""),
    PLUGIN_DIR(1025, ""),
    PORT(1025, "0"),
    PRELOAD_BUFFER_SIZE(2, "32768"),
    PRINT_IDENTIFIED_WITH_AS_HEX(2, "0"),
    PROFILING(2, "0"),
    PROFILING_HISTORY_SIZE(2, "15"),
    PROTOCOL_COMPRESSION_ALGORITHMS(1, "zlib,zstd,uncompressed"),
    PROTOCOL_VERSION(1025, "10"),
    PROXY_USER(1028, ""),
    PSEUDO_REPLICA_MODE(4, "0"),
    PSEUDO_SLAVE_MODE(4, "0"),
    PSEUDO_THREAD_ID(4, "0"),
    QUERY_ALLOC_BLOCK_SIZE(2, "8192"),
    QUERY_PREALLOC_SIZE(2, "8192"),
    RAND_SEED1(4, "0"),
    RAND_SEED2(4, "0"),
    RANGE_ALLOC_BLOCK_SIZE(32770, "4096"),
    RANGE_OPTIMIZER_MAX_MEM_SIZE(32770, "8388608"),
    READ_BUFFER_SIZE(32770, "131072"),
    READ_ONLY(1, "0"),
    READ_RND_BUFFER_SIZE(32770, "262144"),
    REGEXP_STACK_LIMIT(1, "8000000"),
    REGEXP_TIME_LIMIT(1, "32"),
    RELAY_LOG(1025, ""),
    RELAY_LOG_BASENAME(1025, ""),
    RELAY_LOG_INDEX(1025, ""),
    RELAY_LOG_INFO_FILE(1025, ""),
    RELAY_LOG_PURGE(1, "1"),
    RELAY_LOG_RECOVERY(1025, "0"),
    RELAY_LOG_SPACE_LIMIT(1025, "0"),
    REPLICA_ALLOW_BATCHING(1, "1"),
    REPLICA_CHECKPOINT_GROUP(1, "512"),
    REPLICA_CHECKPOINT_PERIOD(1, "300"),
    REPLICA_COMPRESSED_PROTOCOL(1, "0"),
    REPLICA_LOAD_TMPDIR(1025, ""),
    REPLICA_MAX_ALLOWED_PACKET(1, "1073741824"),
    REPLICA_NET_TIMEOUT(1, "60"),
    REPLICA_PARALLEL_WORKERS(65537, "4"),
    REPLICA_PENDING_JOBS_SIZE_MAX(1, "134217728"),
    REPLICA_PRESERVE_COMMIT_ORDER(65537, "1"),
    REPLICA_SKIP_ERRORS(1025, ""),
    REPLICA_SQL_VERIFY_CHECKSUM(1, "1"),
    REPLICA_TRANSACTION_RETRIES(1, "10"),
    REPLICATION_OPTIMIZE_FOR_STATIC_PLUGIN_CONFIG(1, "0"),
    REPLICATION_SENDER_OBSERVE_COMMIT_ONLY(1, "0"),
    REPORT_HOST(1025, ""),
    REPORT_PASSWORD(1025, ""),
    REPORT_PORT(1025, "0"),
    REPORT_USER(1025, ""),
    REQUIRE_ROW_FORMAT(4, "0"),
    REQUIRE_SECURE_TRANSPORT(1, "0"),
    RPL_READ_SIZE(1, "8192"),
    RPL_STOP_REPLICA_TIMEOUT(1, "31536000"),
    RPL_STOP_SLAVE_TIMEOUT(1, "31536000"),
    SCHEMA_DEFINITION_CACHE(1, "256"),
    SECONDARY_ENGINE_COST_THRESHOLD(32770, "4.68161e+18"),
    SECURE_FILE_PRIV(1025, "NULL"),
    SELECT_INTO_BUFFER_SIZE(32770, "131072"),
    SELECT_INTO_DISK_SYNC(32770, "0"),
    SELECT_INTO_DISK_SYNC_DELAY(32770, "0"),
    SERVER_ID(65537, "1"),
    SERVER_ID_BITS(1, "32"),
    SERVER_UUID(1025, ""),
    SESSION_TRACK_SCHEMA(2, "1"),
    SESSION_TRACK_STATE_CHANGE(2, "0"),
    SESSION_TRACK_SYSTEM_VARIABLES(2, "time_zone,autocommit,character_set_client,character_set_results,character_set_connection"),
    SHA256_PASSWORD_PROXY_USERS(1, "0"),
    SHOW_CREATE_TABLE_SKIP_SECONDARY_ENGINE(4, "0"),
    SHOW_CREATE_TABLE_VERBOSITY(2, "0"),
    SHOW_GIPK_IN_CREATE_TABLE_AND_INFORMATION_SCHEMA(2, "1"),
    SHOW_OLD_TEMPORALS(2, "0"),
    SKIP_EXTERNAL_LOCKING(1025, "1"),
    SKIP_NAME_RESOLVE(1025, "0"),
    SKIP_NETWORKING(1025, "0"),
    SKIP_REPLICA_START(1025, "0"),
    SKIP_SHOW_DATABASE(1025, "0"),
    SKIP_SLAVE_START(1025, "0"),
    SLAVE_ALLOW_BATCHING(1, "1"),
    SLAVE_CHECKPOINT_GROUP(1, "512"),
    SLAVE_CHECKPOINT_PERIOD(1, "300"),
    SLAVE_COMPRESSED_PROTOCOL(1, "0"),
    SLAVE_EXEC_MODE(1, "STRICT"),
    SLAVE_LOAD_TMPDIR(1025, ""),
    SLAVE_MAX_ALLOWED_PACKET(1, "1073741824"),
    SLAVE_NET_TIMEOUT(1, "60"),
    SLAVE_PARALLEL_TYPE(65537, "LOGICAL_CLOCK"),
    SLAVE_PARALLEL_WORKERS(65537, "4"),
    SLAVE_PENDING_JOBS_SIZE_MAX(1, "134217728"),
    SLAVE_PRESERVE_COMMIT_ORDER(65537, "1"),
    SLAVE_ROWS_SEARCH_ALGORITHMS(1, "INDEX_SCAN,HASH_SCAN"),
    SLAVE_SKIP_ERRORS(1025, ""),
    SLAVE_SQL_VERIFY_CHECKSUM(1, "1"),
    SLAVE_TRANSACTION_RETRIES(1, "10"),
    SLAVE_TYPE_CONVERSIONS(1, ""),
    SLOW_LAUNCH_TIME(1, "2"),
    SLOW_QUERY_LOG(1, "0"),
    SLOW_QUERY_LOG_FILE(1, ""),
    SOCKET(1025, ""),
    SORT_BUFFER_SIZE(32770, "262144"),
    SOURCE_VERIFY_CHECKSUM(1, "0"),
    SQL_AUTO_IS_NULL(32770, "0"),
    SQL_BIG_SELECTS(32770, "0"),
    SQL_BUFFER_RESULT(32770, "0"),
    SQL_GENERATE_INVISIBLE_PRIMARY_KEY(2, "0"),
    SQL_LOG_BIN(4, "1"),
    SQL_LOG_OFF(2, "0"),
    SQL_MODE(32770, "ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION"),
    SQL_NOTES(2, "1"),
    SQL_QUOTE_SHOW_CREATE(2, "1"),
    SQL_REPLICA_SKIP_COUNTER(1, "0"),
    SQL_REQUIRE_PRIMARY_KEY(32770, "0"),
    SQL_SAFE_UPDATES(32770, "0"),
    SQL_SELECT_LIMIT(32770, "18446744073709551615"),
    SQL_SLAVE_SKIP_COUNTER(1, "0"),
    SQL_WARNINGS(2, "0"),
    SSL_CA(65537, ""),
    SSL_CAPATH(65537, ""),
    SSL_CERT(65537, ""),
    SSL_CIPHER(65537, ""),
    SSL_CRL(65537, ""),
    SSL_CRLPATH(65537, ""),
    SSL_FIPS_MODE(1, "OFF"),
    SSL_KEY(65537, ""),
    SSL_SESSION_CACHE_MODE(65537, "1"),
    SSL_SESSION_CACHE_TIMEOUT(65537, "300"),
    STORED_PROGRAM_CACHE(1, "256"),
    STORED_PROGRAM_DEFINITION_CACHE(1, "256"),
    SUPER_READ_ONLY(1, "0"),
    SYNC_BINLOG(1, "1"),
    SYNC_MASTER_INFO(1, "10000"),
    SYNC_RELAY_LOG(1, "10000"),
    SYNC_RELAY_LOG_INFO(1, "10000"),
    SYNC_SOURCE_INFO(1, "10000"),
    SYSTEM_TIME_ZONE(1025, "UTC"),
    TABLE_DEFINITION_CACHE(1, "400"),
    TABLE_ENCRYPTION_PRIVILEGE_CHECK(1, "0"),
    TABLE_OPEN_CACHE(1, "4000"),
    TABLE_OPEN_CACHE_INSTANCES(1025, "16"),
    TABLESPACE_DEFINITION_CACHE(1, "256"),
    TEMPTABLE_MAX_MMAP(1, "1073741824"),
    TEMPTABLE_MAX_RAM(1, "1073741824"),
    TEMPTABLE_USE_MMAP(1, "1"),
    TERMINOLOGY_USE_PREVIOUS(2, "NONE"),
    THREAD_CACHE_SIZE(1, "0"),
    THREAD_HANDLING(1025, "one-thread-per-connection"),
    THREAD_STACK(1025, "1048576"),
    TIME_ZONE(32770, "SYSTEM"),
    TIMESTAMP(32772, "0"),
    TLS_CIPHERSUITES(65537, ""),
    TLS_VERSION(65537, "TLSv1.2,TLSv1.3"),
    TMP_TABLE_SIZE(32770, "16777216"),
    TMPDIR(1025, ""),
    TRANSACTION_ALLOC_BLOCK_SIZE(2, "8192"),
    TRANSACTION_ALLOW_BATCHING(4, "0"),
    TRANSACTION_ISOLATION(8194, "REPEATABLE-READ", new TransactionIsolationValueProvider()),
    TRANSACTION_PREALLOC_SIZE(2, "4096"),
    TRANSACTION_READ_ONLY(8194, "0", new TransactionReadOnlyValueProvider()),
    TRANSACTION_WRITE_SET_EXTRACTION(2, "XXHASH64"),
    UNIQUE_CHECKS(32770, "1"),
    UPDATABLE_VIEWS_WITH_LIMIT(32770, "YES"),
    USE_SECONDARY_ENGINE(32772, "ON"),
    VALIDATE_USER_PLUGINS(5121, "1"),
    VERSION(1025, DatabaseProtocolServerInfo.getDefaultProtocolVersion((DatabaseType)((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL"))), new VersionValueProvider()),
    VERSION_COMMENT(1025, "Source distribution"),
    VERSION_COMPILE_MACHINE(1025, "x86_64"),
    VERSION_COMPILE_OS(1025, "Linux"),
    VERSION_COMPILE_ZLIB(1025, "1.2.13"),
    WAIT_TIMEOUT(2, "28800"),
    WARNING_COUNT(1028, "0"),
    WINDOWING_USE_HIGH_PRECISION(32770, "1"),
    XA_DETACH_ON_PREPARE(32770, "1"),
    DATE_FORMAT(1025, "%Y-%m-%d"),
    DATETIME_FORMAT(1025, "%Y-%m-%d %H:%i:%s"),
    HAVE_CRYPT(1025, "NO"),
    IGNORE_BUILTIN_INNODB(1025, "0"),
    IGNORE_DB_DIRS(1025, ""),
    INTERNAL_TMP_DISK_STORAGE_ENGINE(1, "InnoDB"),
    LOG_BUILTIN_AS_IDENTIFIED_BY_PASSWORD(1, "0"),
    LOG_SYSLOG(1, "0"),
    LOG_SYSLOG_FACILITY(1, "daemon"),
    LOG_SYSLOG_INCLUDE_PID(1, "1"),
    LOG_SYSLOG_TAG(1, ""),
    LOG_WARNINGS(1, "2"),
    MAX_TMP_TABLES(2, "32"),
    METADATA_LOCKS_CACHE_SIZE(1025, "1024"),
    METADATA_LOCKS_HASH_INSTANCES(1025, "8"),
    MULTI_RANGE_COUNT(2, "256"),
    OLD_PASSWORDS(2, "0"),
    QUERY_CACHE_LIMIT(1, "1048576"),
    QUERY_CACHE_MIN_RES_UNIT(1, "4096"),
    QUERY_CACHE_SIZE(1, "1048576"),
    QUERY_CACHE_TYPE(2, "OFF"),
    QUERY_CACHE_WLOCK_INVALIDATE(2, "0"),
    SECURE_AUTH(1, "1"),
    SHOW_COMPATIBILITY_56(1, "0"),
    SYNC_FRM(1, "1"),
    TIME_FORMAT(1025, "%H:%i:%s"),
    TX_ISOLATION(8194, "REPEATABLE-READ", new TransactionIsolationValueProvider()),
    TX_READ_ONLY(8194, "0", new TransactionReadOnlyValueProvider()),
    BINLOGGING_IMPOSSIBLE_MODE(1, "IGNORE_ERROR"),
    SIMPLIFIED_BINLOG_GTID_RECOVERY(1024, "0"),
    STORAGE_ENGINE(2, ""),
    THREAD_CONCURRENCY(1024, "10"),
    TIMED_MUTEXES(1, "0");

    private static final Map<String, MySQLSystemVariable> ALL_VARIABLES;
    private final int flag;
    private final String defaultValue;
    private final MySQLSystemVariableValueProvider variableValueProvider;

    private MySQLSystemVariable(int flag, String defaultValue) {
        this(flag, defaultValue, MySQLSystemVariableValueProvider.DEFAULT_PROVIDER);
    }

    public static Optional<MySQLSystemVariable> findSystemVariable(String name) {
        return Optional.ofNullable(ALL_VARIABLES.get(name.toUpperCase()));
    }

    public String getValue(Scope scope, ConnectionSession connectionSession) {
        this.validateGetScope(scope);
        return this.variableValueProvider.get(scope, connectionSession, this);
    }

    private void validateGetScope(Scope scope) {
        if (Scope.GLOBAL == scope) {
            ShardingSpherePreconditions.checkState((0 == (4 & this.scope()) ? 1 : 0) != 0, () -> new IncorrectGlobalLocalVariableException(this.name().toLowerCase(), Scope.SESSION.name()));
        }
        if (Scope.SESSION == scope) {
            ShardingSpherePreconditions.checkState((0 != (6 & this.scope()) ? 1 : 0) != 0, () -> new IncorrectGlobalLocalVariableException(this.name().toLowerCase(), Scope.GLOBAL.name()));
        }
    }

    public void validateSetTargetScope(Scope scope) {
        if (Scope.GLOBAL == scope) {
            ShardingSpherePreconditions.checkState((0 == (4 & this.scope()) ? 1 : 0) != 0, () -> new ErrorLocalVariableException(this.name().toLowerCase()));
        }
        if (Scope.SESSION == scope) {
            ShardingSpherePreconditions.checkState((0 != (6 & this.scope()) ? 1 : 0) != 0, () -> new ErrorGlobalVariableException(this.name().toLowerCase()));
        }
    }

    private int scope() {
        return 0x3FF & this.flag;
    }

    @Generated
    private MySQLSystemVariable(int flag, String defaultValue, MySQLSystemVariableValueProvider variableValueProvider) {
        this.flag = flag;
        this.defaultValue = defaultValue;
        this.variableValueProvider = variableValueProvider;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    static {
        ALL_VARIABLES = Arrays.stream(MySQLSystemVariable.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
    }
}

