/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.api.internal;

import java.util.Objects;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;
import org.apache.shardingsphere.shade.io.opentelemetry.context.ContextKey;

public final class InstrumentationUtil {
    private static final ContextKey<Boolean> SUPPRESS_INSTRUMENTATION_KEY = ContextKey.named("suppress_instrumentation");

    private InstrumentationUtil() {
    }

    public static void suppressInstrumentation(Runnable runnable2) {
        Context.current().with(SUPPRESS_INSTRUMENTATION_KEY, true).wrap(runnable2).run();
    }

    public static boolean shouldSuppressInstrumentation(Context context) {
        return Objects.equals(context.get(SUPPRESS_INSTRUMENTATION_KEY), true);
    }
}

