/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.common.v1.internal.AnyValue;

final class BytesAnyValueMarshaler
extends MarshalerWithSize {
    private final byte[] value;

    private BytesAnyValueMarshaler(byte[] value) {
        super(BytesAnyValueMarshaler.calculateSize(value));
        this.value = value;
    }

    static MarshalerWithSize create(ByteBuffer value) {
        byte[] bytes = new byte[value.remaining()];
        value.get(bytes);
        return new BytesAnyValueMarshaler(bytes);
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeBytes(AnyValue.BYTES_VALUE, this.value);
    }

    private static int calculateSize(byte[] value) {
        return AnyValue.BYTES_VALUE.getTagSize() + CodedOutputStream.computeByteArraySizeNoTag(value);
    }
}

