/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.internal;

import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.internal.OtlpConfigUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.internal.StructuredConfigProperties;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.export.LogRecordExporter;

public class OtlpLogRecordExporterComponentProvider
implements ComponentProvider<LogRecordExporter> {
    @Override
    public Class<LogRecordExporter> getType() {
        return LogRecordExporter.class;
    }

    @Override
    public String getName() {
        return "otlp";
    }

    @Override
    public LogRecordExporter create(StructuredConfigProperties config) {
        String protocol = OtlpConfigUtil.getStructuredConfigOtlpProtocol(config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpLogRecordExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcLogRecordExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    OtlpHttpLogRecordExporterBuilder httpBuilder() {
        return OtlpHttpLogRecordExporter.builder();
    }

    OtlpGrpcLogRecordExporterBuilder grpcBuilder() {
        return OtlpGrpcLogRecordExporter.builder();
    }
}

