/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.shardingsphere.shade.io.opentelemetry.api.internal.Utils;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SpanExporter;

public final class BatchSpanProcessorBuilder {
    static final long DEFAULT_SCHEDULE_DELAY_MILLIS = 5000L;
    static final int DEFAULT_MAX_QUEUE_SIZE = 2048;
    static final int DEFAULT_MAX_EXPORT_BATCH_SIZE = 512;
    static final int DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000;
    private final SpanExporter spanExporter;
    private boolean exportUnsampledSpans = false;
    private long scheduleDelayNanos = TimeUnit.MILLISECONDS.toNanos(5000L);
    private int maxQueueSize = 2048;
    private int maxExportBatchSize = 512;
    private long exporterTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(30000L);
    private MeterProvider meterProvider = MeterProvider.noop();

    BatchSpanProcessorBuilder(SpanExporter spanExporter) {
        this.spanExporter = Objects.requireNonNull(spanExporter, "spanExporter");
    }

    public BatchSpanProcessorBuilder setExportUnsampledSpans(boolean exportUnsampledSpans) {
        this.exportUnsampledSpans = exportUnsampledSpans;
        return this;
    }

    public BatchSpanProcessorBuilder setScheduleDelay(long delay, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(delay >= 0L, "delay must be non-negative");
        this.scheduleDelayNanos = unit.toNanos(delay);
        return this;
    }

    public BatchSpanProcessorBuilder setScheduleDelay(Duration delay) {
        Objects.requireNonNull(delay, "delay");
        return this.setScheduleDelay(delay.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getScheduleDelayNanos() {
        return this.scheduleDelayNanos;
    }

    public BatchSpanProcessorBuilder setExporterTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.exporterTimeoutNanos = unit.toNanos(timeout2);
        return this;
    }

    public BatchSpanProcessorBuilder setExporterTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        return this.setExporterTimeout(timeout2.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getExporterTimeoutNanos() {
        return this.exporterTimeoutNanos;
    }

    public BatchSpanProcessorBuilder setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public BatchSpanProcessorBuilder setMaxExportBatchSize(int maxExportBatchSize) {
        Utils.checkArgument(maxExportBatchSize > 0, "maxExportBatchSize must be positive.");
        this.maxExportBatchSize = maxExportBatchSize;
        return this;
    }

    public BatchSpanProcessorBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProvider = meterProvider;
        return this;
    }

    int getMaxExportBatchSize() {
        return this.maxExportBatchSize;
    }

    public BatchSpanProcessor build() {
        return new BatchSpanProcessor(this.spanExporter, this.exportUnsampledSpans, this.meterProvider, this.scheduleDelayNanos, this.maxQueueSize, this.maxExportBatchSize, this.exporterTimeoutNanos);
    }
}

