/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.projection;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.ParenthesesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptProjectionTokenGenerator {
    private final List<SQLToken> previousSQLTokens;
    private final EncryptRule encryptRule;
    private final DatabaseType databaseType;

    public Collection<SQLToken> generateSQLTokens(SelectStatementContext selectStatementContext) {
        LinkedHashSet<SQLToken> result = new LinkedHashSet<SQLToken>(this.generateSelectSQLTokens(selectStatementContext));
        selectStatementContext.getSubqueryContexts().values().stream().map(this::generateSelectSQLTokens).forEach(result::addAll);
        return result;
    }

    private Collection<SQLToken> generateSelectSQLTokens(SelectStatementContext selectStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ProjectionSegment each : selectStatementContext.getSqlStatement().getProjections().getProjections()) {
            ShorthandProjectionSegment shorthandSegment;
            Collection actualColumns;
            if (each instanceof ColumnProjectionSegment) {
                this.generateSQLToken(selectStatementContext, (ColumnProjectionSegment)each).ifPresent(result::add);
            }
            if (!(each instanceof ShorthandProjectionSegment) || (actualColumns = this.getShorthandProjection(shorthandSegment = (ShorthandProjectionSegment)each, selectStatementContext.getProjectionsContext()).getActualColumns()).isEmpty()) continue;
            result.add((SQLToken)this.generateSQLToken(shorthandSegment, actualColumns, selectStatementContext, selectStatementContext.getSubqueryType()));
        }
        return result;
    }

    private Optional<SubstitutableColumnNameToken> generateSQLToken(SelectStatementContext selectStatementContext, ColumnProjectionSegment columnSegment) {
        ColumnProjection columnProjection = this.buildColumnProjection(columnSegment);
        String columnName = columnProjection.getOriginalColumn().getValue();
        Optional<EncryptTable> encryptTable = this.encryptRule.findEncryptTable(columnProjection.getOriginalTable().getValue());
        if (encryptTable.isPresent() && encryptTable.get().isEncryptColumn(columnName) && !selectStatementContext.containsTableSubquery()) {
            EncryptColumn encryptColumn = encryptTable.get().getEncryptColumn(columnName);
            Collection<Projection> projections = this.generateProjections(encryptColumn, columnProjection, selectStatementContext.getSubqueryType());
            int startIndex = this.getStartIndex(columnSegment);
            int stopIndex = this.getStopIndex(columnSegment);
            this.previousSQLTokens.removeIf(each -> each.getStartIndex() == startIndex);
            return Optional.of(new SubstitutableColumnNameToken(startIndex, stopIndex, projections, this.databaseType));
        }
        return Optional.empty();
    }

    private SubstitutableColumnNameToken generateSQLToken(ShorthandProjectionSegment segment, Collection<Projection> actualColumns, SelectStatementContext selectStatementContext, SubqueryType subqueryType) {
        LinkedList<Projection> projections = new LinkedList<Projection>();
        for (Projection each2 : actualColumns) {
            ColumnProjection columnProjection;
            Optional<EncryptTable> encryptTable;
            if (each2 instanceof ColumnProjection && (encryptTable = this.encryptRule.findEncryptTable((columnProjection = (ColumnProjection)each2).getOriginalTable().getValue())).isPresent() && encryptTable.get().isEncryptColumn(columnProjection.getOriginalColumn().getValue()) && !selectStatementContext.containsTableSubquery()) {
                EncryptColumn encryptColumn = encryptTable.get().getEncryptColumn(columnProjection.getOriginalColumn().getValue());
                projections.addAll(this.generateProjections(encryptColumn, columnProjection, subqueryType));
                continue;
            }
            projections.add(each2.getAlias().filter(alias -> !DerivedColumn.isDerivedColumnName((String)alias.getValue())).map(optional -> new ColumnProjection(null, optional, null, this.databaseType)).orElse(each2));
        }
        int startIndex = segment.getOwner().isPresent() ? ((OwnerSegment)segment.getOwner().get()).getStartIndex() : segment.getStartIndex();
        this.previousSQLTokens.removeIf(each -> each.getStartIndex() == startIndex);
        return new SubstitutableColumnNameToken(startIndex, segment.getStopIndex(), projections, selectStatementContext.getDatabaseType());
    }

    private int getStartIndex(ColumnProjectionSegment columnSegment) {
        if (columnSegment.getColumn().getLeftParentheses().isPresent()) {
            return ((ParenthesesSegment)columnSegment.getColumn().getLeftParentheses().get()).getStartIndex();
        }
        return columnSegment.getColumn().getOwner().isPresent() ? ((OwnerSegment)columnSegment.getColumn().getOwner().get()).getStartIndex() : columnSegment.getColumn().getStartIndex();
    }

    private int getStopIndex(ColumnProjectionSegment columnSegment) {
        if (columnSegment.getAliasSegment().isPresent()) {
            return ((AliasSegment)columnSegment.getAliasSegment().get()).getStopIndex();
        }
        return columnSegment.getColumn().getRightParentheses().isPresent() ? ((ParenthesesSegment)columnSegment.getColumn().getRightParentheses().get()).getStopIndex() : columnSegment.getColumn().getStopIndex();
    }

    private ColumnProjection buildColumnProjection(ColumnProjectionSegment segment) {
        IdentifierValue owner = segment.getColumn().getOwner().map(OwnerSegment::getIdentifier).orElse(null);
        ColumnProjection result = new ColumnProjection(owner, segment.getColumn().getIdentifier(), segment.getAliasName().isPresent() ? (IdentifierValue)segment.getAlias().orElse(null) : null, this.databaseType, (ParenthesesSegment)segment.getColumn().getLeftParentheses().orElse(null), (ParenthesesSegment)segment.getColumn().getRightParentheses().orElse(null));
        result.setOriginalColumn(segment.getColumn().getColumnBoundInfo().getOriginalColumn());
        result.setOriginalTable(segment.getColumn().getColumnBoundInfo().getOriginalTable());
        return result;
    }

    private Collection<Projection> generateProjections(EncryptColumn encryptColumn, ColumnProjection columnProjection, SubqueryType subqueryType) {
        if (null == subqueryType || SubqueryType.PROJECTION == subqueryType) {
            return Collections.singleton(this.generateProjection(encryptColumn, columnProjection));
        }
        if (SubqueryType.TABLE == subqueryType || SubqueryType.JOIN == subqueryType) {
            return this.generateProjectionsInTableSegmentSubquery(encryptColumn, columnProjection, subqueryType);
        }
        if (SubqueryType.PREDICATE == subqueryType) {
            return Collections.singleton(this.generateProjectionInPredicateSubquery(encryptColumn, columnProjection));
        }
        if (SubqueryType.INSERT_SELECT == subqueryType) {
            return this.generateProjectionsInInsertSelectSubquery(encryptColumn, columnProjection);
        }
        throw new UnsupportedSQLOperationException("Projections not in simple select, table subquery, join subquery, predicate subquery and insert select subquery are not supported in encrypt feature.");
    }

    private ColumnProjection generateProjection(EncryptColumn encryptColumn, ColumnProjection columnProjection) {
        IdentifierValue cipherColumnName = new IdentifierValue(encryptColumn.getCipher().getName(), columnProjection.getName().getQuoteCharacter());
        return new ColumnProjection((IdentifierValue)columnProjection.getOwner().orElse(null), cipherColumnName, columnProjection.getAlias().orElse(columnProjection.getName()), this.databaseType, (ParenthesesSegment)columnProjection.getLeftParentheses().orElse(null), (ParenthesesSegment)columnProjection.getRightParentheses().orElse(null));
    }

    private Collection<Projection> generateProjectionsInTableSegmentSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection, SubqueryType subqueryType) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        QuoteCharacter quoteCharacter = columnProjection.getName().getQuoteCharacter();
        IdentifierValue cipherColumnName = new IdentifierValue(encryptColumn.getCipher().getName(), quoteCharacter);
        IdentifierValue alias = SubqueryType.JOIN == subqueryType ? null : columnProjection.getAlias().orElse(columnProjection.getName());
        ParenthesesSegment leftParentheses = columnProjection.getLeftParentheses().orElse(null);
        ParenthesesSegment rightParentheses = columnProjection.getRightParentheses().orElse(null);
        result.add((Projection)new ColumnProjection((IdentifierValue)columnProjection.getOwner().orElse(null), cipherColumnName, alias, this.databaseType, leftParentheses, rightParentheses));
        IdentifierValue assistedColumOwner = columnProjection.getOwner().orElse(null);
        encryptColumn.getAssistedQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(assistedColumOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)));
        encryptColumn.getLikeQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(assistedColumOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)));
        return result;
    }

    private ColumnProjection generateProjectionInPredicateSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection) {
        QuoteCharacter quoteCharacter = columnProjection.getName().getQuoteCharacter();
        ParenthesesSegment leftParentheses = columnProjection.getLeftParentheses().orElse(null);
        ParenthesesSegment rightParentheses = columnProjection.getRightParentheses().orElse(null);
        IdentifierValue owner = columnProjection.getOwner().orElse(null);
        return encryptColumn.getAssistedQuery().map(optional -> new ColumnProjection(owner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)).orElseGet(() -> new ColumnProjection(owner, new IdentifierValue(encryptColumn.getCipher().getName(), quoteCharacter), columnProjection.getAlias().orElse(columnProjection.getName()), this.databaseType, leftParentheses, rightParentheses));
    }

    private Collection<Projection> generateProjectionsInInsertSelectSubquery(EncryptColumn encryptColumn, ColumnProjection columnProjection) {
        QuoteCharacter quoteCharacter = columnProjection.getName().getQuoteCharacter();
        IdentifierValue columnName = new IdentifierValue(encryptColumn.getCipher().getName(), quoteCharacter);
        LinkedList<Projection> result = new LinkedList<Projection>();
        ParenthesesSegment leftParentheses = columnProjection.getLeftParentheses().orElse(null);
        ParenthesesSegment rightParentheses = columnProjection.getRightParentheses().orElse(null);
        result.add((Projection)new ColumnProjection((IdentifierValue)columnProjection.getOwner().orElse(null), columnName, null, this.databaseType, leftParentheses, rightParentheses));
        IdentifierValue assistedColumOwner = columnProjection.getOwner().orElse(null);
        encryptColumn.getAssistedQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(assistedColumOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)));
        encryptColumn.getLikeQuery().ifPresent(optional -> result.add((Projection)new ColumnProjection(assistedColumOwner, new IdentifierValue(optional.getName(), quoteCharacter), null, this.databaseType, leftParentheses, rightParentheses)));
        return result;
    }

    private ShorthandProjection getShorthandProjection(ShorthandProjectionSegment segment, ProjectionsContext projectionsContext) {
        Optional owner = segment.getOwner().isPresent() ? Optional.of(((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue()) : Optional.empty();
        for (Projection each : projectionsContext.getProjections()) {
            if (!(each instanceof ShorthandProjection)) continue;
            if (!owner.isPresent() && !((ShorthandProjection)each).getOwner().isPresent()) {
                return (ShorthandProjection)each;
            }
            if (!owner.isPresent() || !((String)owner.get()).equals(((ShorthandProjection)each).getOwner().map(IdentifierValue::getValue).orElse(null))) continue;
            return (ShorthandProjection)each;
        }
        throw new IllegalStateException(String.format("Can not find shorthand projection segment, owner is `%s`", owner.orElse(null)));
    }

    @Generated
    public EncryptProjectionTokenGenerator(List<SQLToken> previousSQLTokens, EncryptRule encryptRule, DatabaseType databaseType) {
        this.previousSQLTokens = previousSQLTokens;
        this.encryptRule = encryptRule;
        this.databaseType = databaseType;
    }
}

