/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.hostchooser;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opengauss.Driver;
import org.opengauss.PGProperty;
import org.opengauss.QueryCNListUtils;
import org.opengauss.hostchooser.CandidateHost;
import org.opengauss.hostchooser.GlobalHostStatusTracker;
import org.opengauss.hostchooser.HostChooser;
import org.opengauss.hostchooser.HostRequirement;
import org.opengauss.log.Log;
import org.opengauss.log.Logger;
import org.opengauss.util.HostSpec;
import org.opengauss.util.PSQLException;

public class MultiHostChooser
implements HostChooser {
    private HostSpec[] hostSpecs;
    private final HostRequirement targetServerType;
    private int hostRecheckTime;
    private boolean loadBalance;
    private LoadBalanceType loadBalanceType;
    private String URLIdentifier;
    private Properties info;
    private static Log LOGGER = Logger.getLogger(MultiHostChooser.class.getName());
    private static final int MAX_CONNECT_NUM = 0x40000000;
    private static Map<String, Integer> roundRobinCounter = new HashMap<String, Integer>();

    MultiHostChooser(HostSpec[] hostSpecs, HostRequirement targetServerType, Properties info) {
        this.hostSpecs = hostSpecs;
        this.targetServerType = targetServerType;
        this.loadBalanceType = this.initLoadBalanceType(info);
        this.URLIdentifier = QueryCNListUtils.keyFromURL(info);
        this.info = info;
        try {
            this.hostRecheckTime = PGProperty.HOST_RECHECK_SECONDS.getInt(info) * 1000;
        }
        catch (PSQLException e) {
            throw new RuntimeException(e);
        }
    }

    private LoadBalanceType initLoadBalanceType(Properties info) {
        String autoBalance = info.getProperty("autoBalance", "false");
        if (autoBalance.equals("roundrobin") || autoBalance.equals("true") || autoBalance.equals("balance")) {
            return LoadBalanceType.RoundRobin;
        }
        if (autoBalance.contains("priority")) {
            return LoadBalanceType.PriorityRoundRobin;
        }
        if (autoBalance.equals("leastconn")) {
            return LoadBalanceType.LeastConn;
        }
        if (PGProperty.LOAD_BALANCE_HOSTS.getBoolean(info) || autoBalance.equals("shuffle")) {
            return LoadBalanceType.Shuffle;
        }
        return LoadBalanceType.NONE;
    }

    private List<HostSpec> loadBalance(List<HostSpec> allHosts) {
        Boolean isOutPutLog = true;
        if (allHosts.size() <= 1) {
            return allHosts;
        }
        switch (this.loadBalanceType) {
            case Shuffle: {
                allHosts = new ArrayList<HostSpec>(allHosts);
                Collections.shuffle(allHosts);
                break;
            }
            case RoundRobin: {
                allHosts = this.roundRobin(allHosts);
                break;
            }
            case PriorityRoundRobin: {
                allHosts = this.priorityRoundRobin(allHosts);
                break;
            }
            case LeastConn: {
                break;
            }
            default: {
                isOutPutLog = false;
            }
        }
        if (isOutPutLog.booleanValue()) {
            LOGGER.info("[AUTOBALANCE] The load balancing result of the cluster is: | Cluster: " + this.URLIdentifier + " | LoadBalanceResult: " + allHosts);
        }
        return allHosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRRIndex() {
        Map<String, Integer> map = roundRobinCounter;
        synchronized (map) {
            int value = roundRobinCounter.getOrDefault(this.URLIdentifier, 0);
            value = (value + 1) % 0x40000000;
            roundRobinCounter.put(this.URLIdentifier, value);
            return value;
        }
    }

    private List<HostSpec> roundRobin(List<HostSpec> hostSpecs) {
        if (hostSpecs.size() <= 1) {
            return hostSpecs;
        }
        int index = this.getRRIndex() % hostSpecs.size();
        ArrayList<HostSpec> result = new ArrayList<HostSpec>(hostSpecs.size());
        for (int i = 0; i < hostSpecs.size(); ++i) {
            int primitiveIndex = (index + i) % hostSpecs.size();
            result.add(hostSpecs.get(primitiveIndex));
        }
        Collections.shuffle(result.subList(1, result.size()));
        return result;
    }

    private List<HostSpec> priorityRoundRobin(List<HostSpec> hostSpecs) {
        List<HostSpec> urlHostSpecs;
        int priorityCNNumber = Integer.parseInt(this.info.getProperty("autoBalance").substring("priority".length()));
        if (PGProperty.PRIORITY_SERVERS.get(this.info) != null) {
            urlHostSpecs = this.getUrlHostSpecs(hostSpecs);
            if (priorityCNNumber > urlHostSpecs.size()) {
                priorityCNNumber = urlHostSpecs.size();
            }
        } else {
            urlHostSpecs = Arrays.asList(Driver.getURLHostSpecs(this.info));
        }
        List<HostSpec> priorityURLHostSpecs = this.getSurvivalPriorityURLHostSpecs(hostSpecs, urlHostSpecs, priorityCNNumber);
        List<HostSpec> nonPriorityHostSpecs = this.getNonPriorityHostSpecs(hostSpecs, priorityURLHostSpecs);
        if (priorityURLHostSpecs.size() > 0) {
            List<HostSpec> resultHostSpecs = this.roundRobin(priorityURLHostSpecs);
            Collections.shuffle(nonPriorityHostSpecs);
            resultHostSpecs.addAll(nonPriorityHostSpecs);
            return resultHostSpecs;
        }
        return this.roundRobin(hostSpecs);
    }

    private List<HostSpec> getUrlHostSpecs(List<HostSpec> hostSpecs) {
        HostSpec[] urlHostSpecs = Driver.getURLHostSpecs(this.info);
        Integer index = Integer.valueOf(PGProperty.PRIORITY_SERVERS.get(this.info));
        HostSpec[] imaginaryMasterHostSpec = Arrays.copyOfRange(urlHostSpecs, 0, (int)index);
        HostSpec[] imaginarySlaveHostSpec = Arrays.copyOfRange(urlHostSpecs, (int)index, urlHostSpecs.length);
        Object[] currentHostSpecs = hostSpecs.toArray(new HostSpec[0]);
        if (Arrays.toString(currentHostSpecs).contains(imaginaryMasterHostSpec[0].toString())) {
            return Arrays.asList(imaginaryMasterHostSpec);
        }
        return Arrays.asList(imaginarySlaveHostSpec);
    }

    private List<HostSpec> getSurvivalPriorityURLHostSpecs(List<HostSpec> hostSpecs, List<HostSpec> urlHostSpecs, int priorityCNNumber) {
        ArrayList<HostSpec> priorityURLHostSpecs = new ArrayList<HostSpec>();
        block0: for (int i = 0; i < priorityCNNumber; ++i) {
            HostSpec urlHostSpec = urlHostSpecs.get(i);
            for (HostSpec hostSpec : hostSpecs) {
                if (!urlHostSpec.equals(hostSpec)) continue;
                priorityURLHostSpecs.add(urlHostSpec);
                continue block0;
            }
        }
        return priorityURLHostSpecs;
    }

    private List<HostSpec> getNonPriorityHostSpecs(List<HostSpec> hostSpecs, List<HostSpec> priorityURLHostSpecs) {
        ArrayList<HostSpec> nonPriorityHostSpecs = new ArrayList<HostSpec>();
        for (HostSpec hostSpec : hostSpecs) {
            if (priorityURLHostSpecs.contains(hostSpec)) continue;
            nonPriorityHostSpecs.add(hostSpec);
        }
        return nonPriorityHostSpecs;
    }

    public static boolean isVaildPriorityLoadBalance(Properties props) {
        String autoBalance = props.getProperty("autoBalance", "false");
        if (!autoBalance.contains("priority")) {
            return true;
        }
        String priorityLoadBalance = "priority\\d+";
        if (!autoBalance.matches(priorityLoadBalance)) {
            LOGGER.warn("\"autoBalance\" is invaild. When configuring priority load balancing, \"autoBalance\" should be start with priority and end with number.");
            return false;
        }
        String urlPriorityCNNumber = autoBalance.substring("priority".length());
        try {
            int priorityCNNumber = Integer.parseInt(urlPriorityCNNumber);
            int lengthPGPORTURL = props.getProperty("PGPORTURL").split(",").length;
            if (lengthPGPORTURL <= priorityCNNumber) {
                LOGGER.warn("When configuring priority load balancing, the number of CNs with priority should be less than the number of CNs on the URL.");
                return false;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("When configuring priority load balancing, \"autoBalance\" should be end with number.");
            return false;
        }
        return true;
    }

    public static boolean isUsingAutoLoadBalance(Properties props) {
        String autoBalance = props.getProperty("autoBalance", "false");
        return autoBalance.equals("shuffle") || autoBalance.equals("roundrobin") || autoBalance.contains("priority") || autoBalance.equals("leastconn") || autoBalance.equals("true") || autoBalance.equals("balance");
    }

    @Override
    public Iterator<CandidateHost> iterator() {
        Iterator<CandidateHost> res = this.candidateIterator();
        if (!res.hasNext()) {
            List<HostSpec> allHosts = Arrays.asList(this.hostSpecs);
            allHosts = this.loadBalance(allHosts);
            res = this.withReqStatus(this.targetServerType, allHosts).iterator();
        }
        return res;
    }

    private Iterator<CandidateHost> candidateIterator() {
        if (this.targetServerType != HostRequirement.preferSecondary) {
            return this.getCandidateHosts(this.targetServerType).iterator();
        }
        List<CandidateHost> secondaries = this.getCandidateHosts(HostRequirement.secondary);
        List<CandidateHost> any = this.getCandidateHosts(HostRequirement.any);
        if (secondaries.isEmpty()) {
            return any.iterator();
        }
        if (any.isEmpty()) {
            return secondaries.iterator();
        }
        if (secondaries.get(secondaries.size() - 1).equals(any.get(0))) {
            secondaries = this.rtrim(1, secondaries);
        }
        return this.append(secondaries, any).iterator();
    }

    private List<CandidateHost> getCandidateHosts(HostRequirement hostRequirement) {
        List<HostSpec> candidates = GlobalHostStatusTracker.getCandidateHosts(this.hostSpecs, hostRequirement, this.hostRecheckTime);
        candidates = this.loadBalance(candidates);
        return this.withReqStatus(hostRequirement, candidates);
    }

    private List<CandidateHost> withReqStatus(final HostRequirement requirement, final List<HostSpec> hosts) {
        return new AbstractList<CandidateHost>(){

            @Override
            public CandidateHost get(int index) {
                return new CandidateHost((HostSpec)hosts.get(index), requirement);
            }

            @Override
            public int size() {
                return hosts.size();
            }
        };
    }

    private <T> List<T> append(final List<T> a, final List<T> b) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return index < a.size() ? a.get(index) : b.get(index - a.size());
            }

            @Override
            public int size() {
                return a.size() + b.size();
            }
        };
    }

    private <T> List<T> rtrim(final int size, final List<T> a) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return a.get(index);
            }

            @Override
            public int size() {
                return Math.max(0, a.size() - size);
            }
        };
    }

    private static enum LoadBalanceType {
        Shuffle,
        RoundRobin,
        PriorityRoundRobin,
        LeastConn,
        NONE;

    }
}

