/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.route;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.shardingsphere.broadcast.route.engine.BroadcastRouteEngineFactory;
import org.apache.shardingsphere.broadcast.rule.BroadcastRule;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CloseStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.CursorAvailable;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.route.DecorateSQLRouter;
import org.apache.shardingsphere.infra.route.EntranceSQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.tcl.TCLStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLCreateResourceGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dal.MySQLSetResourceGroupStatement;

public final class BroadcastSQLRouter
implements EntranceSQLRouter<BroadcastRule>,
DecorateSQLRouter<BroadcastRule> {
    public RouteContext createRouteContext(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, BroadcastRule rule, ConfigurationProperties props) {
        RouteContext result = new RouteContext();
        BroadcastRouteEngineFactory.newInstance(rule, database, queryContext).route(result, rule);
        return result;
    }

    public void decorateRouteContext(RouteContext routeContext, QueryContext queryContext, ShardingSphereDatabase database, BroadcastRule broadcastRule, ConfigurationProperties props) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof TCLStatement) {
            this.routeToAllDatabase(routeContext, broadcastRule);
        }
        if (sqlStatement instanceof DDLStatement) {
            this.decorateRouteContextWhenDDLStatement(routeContext, queryContext, database, broadcastRule);
        }
        if (sqlStatement instanceof DALStatement && this.isResourceGroupStatement(sqlStatement)) {
            this.routeToAllDatabaseInstance(routeContext, database, broadcastRule);
        }
        if (sqlStatement instanceof DCLStatement && !this.isDCLForSingleTable(queryContext.getSqlStatementContext())) {
            this.routeToAllDatabaseInstance(routeContext, database, broadcastRule);
        }
    }

    private void decorateRouteContextWhenDDLStatement(RouteContext routeContext, QueryContext queryContext, ShardingSphereDatabase database, BroadcastRule broadcastRule) {
        List<String> tableNames;
        boolean procedureStatement;
        SQLStatement sqlStatement;
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        if (sqlStatementContext instanceof CursorAvailable) {
            if (sqlStatementContext instanceof CloseStatementContext && ((CloseStatementContext)sqlStatementContext).getSqlStatement().isCloseAll()) {
                this.routeToAllDatabase(routeContext, broadcastRule);
            }
            return;
        }
        if (sqlStatementContext instanceof IndexAvailable && !routeContext.getRouteUnits().isEmpty()) {
            this.putAllBroadcastTables(routeContext, broadcastRule, sqlStatementContext);
        }
        boolean functionStatement = (sqlStatement = sqlStatementContext.getSqlStatement()) instanceof CreateFunctionStatement || sqlStatement instanceof AlterFunctionStatement || sqlStatement instanceof DropFunctionStatement;
        boolean bl = procedureStatement = sqlStatement instanceof CreateProcedureStatement || sqlStatement instanceof AlterProcedureStatement || sqlStatement instanceof DropProcedureStatement;
        if (functionStatement || procedureStatement) {
            this.routeToAllDatabase(routeContext, broadcastRule);
            return;
        }
        if (sqlStatement instanceof CreateTablespaceStatement || sqlStatement instanceof AlterTablespaceStatement || sqlStatement instanceof DropTablespaceStatement) {
            this.routeToAllDatabaseInstance(routeContext, database, broadcastRule);
        }
        Collection<String> collection = tableNames = sqlStatementContext instanceof TableAvailable ? this.getTableNames((TableAvailable)sqlStatementContext) : Collections.emptyList();
        if (broadcastRule.isAllBroadcastTables(tableNames)) {
            this.routeToAllDatabaseInstance(routeContext, database, broadcastRule);
        }
    }

    private Collection<String> getTableNames(TableAvailable sqlStatementContext) {
        Collection tableSegments = sqlStatementContext.getTablesContext().getSimpleTables();
        LinkedHashSet<String> result = new LinkedHashSet<String>(tableSegments.size());
        for (SimpleTableSegment each : tableSegments) {
            result.add(each.getTableName().getIdentifier().getValue());
        }
        return result;
    }

    private void putAllBroadcastTables(RouteContext routeContext, BroadcastRule broadcastRule, SQLStatementContext sqlStatementContext) {
        List<String> tableNames = sqlStatementContext instanceof TableAvailable ? ((TableAvailable)sqlStatementContext).getTablesContext().getTableNames() : Collections.emptyList();
        for (String each : broadcastRule.getBroadcastRuleTableNames(tableNames)) {
            for (RouteUnit routeUnit : routeContext.getRouteUnits()) {
                routeUnit.getTableMappers().add(new RouteMapper(each, each));
            }
        }
    }

    private boolean isResourceGroupStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof MySQLCreateResourceGroupStatement || sqlStatement instanceof MySQLSetResourceGroupStatement;
    }

    private boolean isDCLForSingleTable(SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext instanceof TableAvailable) {
            TableAvailable tableSegmentsAvailable = (TableAvailable)sqlStatementContext;
            return 1 == tableSegmentsAvailable.getTablesContext().getSimpleTables().size() && !"*".equals(((SimpleTableSegment)tableSegmentsAvailable.getTablesContext().getSimpleTables().iterator().next()).getTableName().getIdentifier().getValue());
        }
        return false;
    }

    private void routeToAllDatabaseInstance(RouteContext routeContext, ShardingSphereDatabase database, BroadcastRule broadcastRule) {
        routeContext.getRouteUnits().clear();
        for (String each : broadcastRule.getDataSourceNames()) {
            if (!database.getResourceMetaData().getAllInstanceDataSourceNames().contains(each)) continue;
            routeContext.getRouteUnits().add(new RouteUnit(new RouteMapper(each, each), Collections.emptyList()));
        }
    }

    private void routeToAllDatabase(RouteContext routeContext, BroadcastRule broadcastRule) {
        routeContext.getRouteUnits().clear();
        for (String each : broadcastRule.getDataSourceNames()) {
            routeContext.getRouteUnits().add(new RouteUnit(new RouteMapper(each, each), Collections.emptyList()));
        }
    }

    public int getOrder() {
        return 5;
    }

    public Class<BroadcastRule> getTypeClass() {
        return BroadcastRule.class;
    }
}

