/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.rex.RexCall;

public class ReflectiveCallNotNullImplementor
implements NotNullImplementor {
    protected final Method method;

    public ReflectiveCallNotNullImplementor(Method method) {
        this.method = method;
    }

    @Override
    public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
        MethodCallExpression callExpr;
        translatedOperands = EnumUtils.fromInternal(this.method.getParameterTypes(), translatedOperands);
        translatedOperands = EnumUtils.convertAssignableTypes(this.method.getParameterTypes(), translatedOperands);
        if ((this.method.getModifiers() & 8) != 0) {
            callExpr = Expressions.call((Method)this.method, translatedOperands);
        } else {
            Expression target = translator.functionInstance(call, this.method);
            callExpr = Expressions.call((Expression)target, (Method)this.method, translatedOperands);
        }
        if (!ReflectiveCallNotNullImplementor.containsCheckedException(this.method)) {
            return callExpr;
        }
        return translator.handleMethodCheckedExceptions((Expression)callExpr);
    }

    private static boolean containsCheckedException(Method method) {
        Class<?>[] exceptions = method.getExceptionTypes();
        if (exceptions == null || exceptions.length == 0) {
            return false;
        }
        for (Class<?> clazz : exceptions) {
            if (RuntimeException.class.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

