/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.text.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.connection.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.audit.SQLAuditEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupReportContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;

public final class MySQLMultiStatementsHandler
implements ProxyBackendHandler {
    private static final Pattern MULTI_UPDATE_STATEMENTS = Pattern.compile(";(?=\\s*update)", 2);
    private static final Pattern MULTI_DELETE_STATEMENTS = Pattern.compile(";(?=\\s*delete)", 2);
    private final KernelProcessor kernelProcessor = new KernelProcessor();
    private final JDBCExecutor jdbcExecutor;
    private final ConnectionSession connectionSession;
    private final SQLStatement sqlStatementSample;
    private final MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
    private final Collection<QueryContext> multiSQLQueryContexts = new LinkedList<QueryContext>();

    public MySQLMultiStatementsHandler(ConnectionSession connectionSession, SQLStatement sqlStatementSample, String sql) {
        this.jdbcExecutor = new JDBCExecutor(BackendExecutorContext.getInstance().getExecutorEngine(), connectionSession.getConnectionContext());
        connectionSession.getDatabaseConnectionManager().handleAutoCommit();
        this.connectionSession = connectionSession;
        this.sqlStatementSample = sqlStatementSample;
        Pattern pattern = sqlStatementSample instanceof UpdateStatement ? MULTI_UPDATE_STATEMENTS : MULTI_DELETE_STATEMENTS;
        SQLParserEngine sqlParserEngine = this.getSQLParserEngine();
        for (String each : this.extractMultiStatements(pattern, sql)) {
            SQLStatement eachSQLStatement = sqlParserEngine.parse(each, false);
            this.multiSQLQueryContexts.add(this.createQueryContext(each, eachSQLStatement));
        }
    }

    private SQLParserEngine getSQLParserEngine() {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        SQLParserRule sqlParserRule = (SQLParserRule)metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        return sqlParserRule.getSQLParserEngine((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL"));
    }

    private List<String> extractMultiStatements(Pattern pattern, String sql) {
        return Arrays.asList(pattern.split(sql));
    }

    private QueryContext createQueryContext(String sql, SQLStatement sqlStatement) {
        HintValueContext hintValueContext = SQLHintUtils.extractHint((String)sql);
        SQLStatementContext sqlStatementContext = new SQLBindEngine(this.metaDataContexts.getMetaData(), this.connectionSession.getUsedDatabaseName(), hintValueContext).bind(sqlStatement, Collections.emptyList());
        return new QueryContext(sqlStatementContext, sql, Collections.emptyList(), hintValueContext, this.connectionSession.getConnectionContext(), this.metaDataContexts.getMetaData());
    }

    public ResponseHeader execute() throws SQLException {
        Collection rules = this.metaDataContexts.getMetaData().getDatabase(this.connectionSession.getUsedDatabaseName()).getRuleMetaData().getRules();
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine("JDBC.STATEMENT", maxConnectionsSizePerQuery, (DatabaseConnectionManager)this.connectionSession.getDatabaseConnectionManager(), (ExecutorStatementManager)((JDBCBackendStatement)this.connectionSession.getStatementManager()), (StorageResourceOption)new StatementOption(false), rules, this.metaDataContexts.getMetaData().getDatabase(this.connectionSession.getUsedDatabaseName()).getResourceMetaData().getStorageUnits());
        return this.executeMultiStatements((DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection>)prepareEngine);
    }

    private UpdateResponseHeader executeMultiStatements(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine) throws SQLException {
        Collection<ExecutionContext> executionContexts = this.createExecutionContexts();
        Map<String, List<ExecutionUnit>> dataSourcesToExecutionUnits = this.buildDataSourcesToExecutionUnits(executionContexts);
        ExecutionGroupContext executionGroupContext = prepareEngine.prepare(this.connectionSession.getUsedDatabaseName(), executionContexts.iterator().next().getRouteContext(), this.samplingExecutionUnit(dataSourcesToExecutionUnits), new ExecutionGroupReportContext(this.connectionSession.getProcessId(), this.connectionSession.getUsedDatabaseName(), this.connectionSession.getConnectionContext().getGrantee()));
        for (ExecutionGroup each : executionGroupContext.getInputGroups()) {
            for (JDBCExecutionUnit unit : each.getInputs()) {
                this.prepareBatchedStatement(unit, dataSourcesToExecutionUnits);
            }
        }
        return this.executeBatchedStatements((ExecutionGroupContext<JDBCExecutionUnit>)executionGroupContext);
    }

    private Collection<ExecutionContext> createExecutionContexts() {
        LinkedList<ExecutionContext> result = new LinkedList<ExecutionContext>();
        for (QueryContext each : this.multiSQLQueryContexts) {
            result.add(this.createExecutionContext(each));
        }
        return result;
    }

    private Map<String, List<ExecutionUnit>> buildDataSourcesToExecutionUnits(Collection<ExecutionContext> executionContexts) {
        HashMap<String, List<ExecutionUnit>> result = new HashMap<String, List<ExecutionUnit>>();
        for (ExecutionContext each : executionContexts) {
            for (ExecutionUnit executionUnit : each.getExecutionUnits()) {
                result.computeIfAbsent(executionUnit.getDataSourceName(), unused -> new LinkedList()).add(executionUnit);
            }
        }
        return result;
    }

    private ExecutionContext createExecutionContext(QueryContext queryContext) {
        RuleMetaData globalRuleMetaData = this.metaDataContexts.getMetaData().getGlobalRuleMetaData();
        ShardingSphereDatabase currentDatabase = this.metaDataContexts.getMetaData().getDatabase(this.connectionSession.getUsedDatabaseName());
        SQLAuditEngine.audit((QueryContext)queryContext, (RuleMetaData)globalRuleMetaData, (ShardingSphereDatabase)currentDatabase);
        return this.kernelProcessor.generateExecutionContext(queryContext, globalRuleMetaData, this.metaDataContexts.getMetaData().getProps(), this.connectionSession.getConnectionContext());
    }

    private Collection<ExecutionUnit> samplingExecutionUnit(Map<String, List<ExecutionUnit>> dataSourcesToExecutionUnits) {
        LinkedList<ExecutionUnit> result = new LinkedList<ExecutionUnit>();
        for (List<ExecutionUnit> each : dataSourcesToExecutionUnits.values()) {
            result.add(each.get(0));
        }
        return result;
    }

    private void prepareBatchedStatement(JDBCExecutionUnit executionUnit, Map<String, List<ExecutionUnit>> dataSourcesToExecutionUnits) throws SQLException {
        Statement statement = executionUnit.getStorageResource();
        for (ExecutionUnit each : dataSourcesToExecutionUnits.get(executionUnit.getExecutionUnit().getDataSourceName())) {
            statement.addBatch(each.getSqlUnit().getSql());
        }
    }

    private UpdateResponseHeader executeBatchedStatements(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext) throws SQLException {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        ResourceMetaData resourceMetaData = this.metaDataContexts.getMetaData().getDatabase(this.connectionSession.getUsedDatabaseName()).getResourceMetaData();
        BatchedJDBCExecutorCallback callback = new BatchedJDBCExecutorCallback(resourceMetaData, this.sqlStatementSample, isExceptionThrown);
        List executeResults = this.jdbcExecutor.execute(executionGroupContext, (JDBCExecutorCallback)callback);
        int updated = 0;
        Iterator iterator = executeResults.iterator();
        while (iterator.hasNext()) {
            int[] eachResult;
            for (int each : eachResult = (int[])iterator.next()) {
                updated += each;
            }
        }
        return new UpdateResponseHeader(this.sqlStatementSample, Collections.singletonList(new UpdateResult(updated, 0L)));
    }

    private static final class BatchedJDBCExecutorCallback
    extends JDBCExecutorCallback<int[]> {
        private BatchedJDBCExecutorCallback(ResourceMetaData resourceMetaData, SQLStatement sqlStatement, boolean isExceptionThrown) {
            super((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL"), resourceMetaData, sqlStatement, isExceptionThrown);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int[] executeSQL(String sql, Statement statement, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
            try {
                int[] nArray = statement.executeBatch();
                return nArray;
            }
            finally {
                statement.close();
            }
        }

        protected Optional<int[]> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
            return Optional.empty();
        }
    }
}

