/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.engine;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableInterpretable;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.Bindable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.table.NoSuchTableException;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessEngine;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.SystemSchemaUtils;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sqlfederation.executor.context.SQLFederationBindContext;
import org.apache.shardingsphere.sqlfederation.executor.context.SQLFederationContext;
import org.apache.shardingsphere.sqlfederation.executor.context.SQLFederationExecutorContext;
import org.apache.shardingsphere.sqlfederation.executor.enumerable.EnumerableScanExecutor;
import org.apache.shardingsphere.sqlfederation.optimizer.SQLFederationCompilerEngine;
import org.apache.shardingsphere.sqlfederation.optimizer.SQLFederationExecutionPlan;
import org.apache.shardingsphere.sqlfederation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.sqlfederation.optimizer.context.planner.OptimizerMetaData;
import org.apache.shardingsphere.sqlfederation.optimizer.exception.SQLFederationSchemaNotFoundException;
import org.apache.shardingsphere.sqlfederation.optimizer.exception.SQLFederationUnsupportedSQLException;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.schema.SQLFederationTable;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.schema.table.ScanExecutor;
import org.apache.shardingsphere.sqlfederation.optimizer.planner.cache.ExecutionPlanCacheKey;
import org.apache.shardingsphere.sqlfederation.optimizer.planner.util.SQLFederationPlannerUtils;
import org.apache.shardingsphere.sqlfederation.optimizer.statement.SQLStatementCompiler;
import org.apache.shardingsphere.sqlfederation.resultset.SQLFederationResultSet;
import org.apache.shardingsphere.sqlfederation.rule.SQLFederationRule;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationDecider;

public final class SQLFederationEngine
implements AutoCloseable {
    private static final int DEFAULT_METADATA_VERSION = 0;
    private static final JavaTypeFactory DEFAULT_DATA_TYPE_FACTORY = new JavaTypeFactoryImpl();
    private final ProcessEngine processEngine = new ProcessEngine();
    private final Map<ShardingSphereRule, SQLFederationDecider> deciders;
    private final String currentDatabaseName;
    private final String currentSchemaName;
    private final ShardingSphereMetaData metaData;
    private final ShardingSphereStatistics statistics;
    private final JDBCExecutor jdbcExecutor;
    private final SQLFederationRule sqlFederationRule;
    private ResultSet resultSet;

    public SQLFederationEngine(String currentDatabaseName, String currentSchemaName, ShardingSphereMetaData metaData, ShardingSphereStatistics statistics, JDBCExecutor jdbcExecutor) {
        this.deciders = OrderedSPILoader.getServices(SQLFederationDecider.class, (Collection)metaData.getDatabase(currentDatabaseName).getRuleMetaData().getRules());
        this.currentDatabaseName = currentDatabaseName;
        this.currentSchemaName = currentSchemaName;
        this.metaData = metaData;
        this.statistics = statistics;
        this.jdbcExecutor = jdbcExecutor;
        this.sqlFederationRule = (SQLFederationRule)metaData.getGlobalRuleMetaData().getSingleRule(SQLFederationRule.class);
    }

    public boolean enabled() {
        return this.sqlFederationRule.getConfiguration().isSqlFederationEnabled();
    }

    public boolean decide(QueryContext queryContext, RuleMetaData globalRuleMetaData) {
        if (this.isQuerySystemSchema(queryContext)) {
            return true;
        }
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        boolean sqlFederationEnabled = this.sqlFederationRule.getConfiguration().isSqlFederationEnabled();
        if (!sqlFederationEnabled || !(sqlStatementContext instanceof SelectStatementContext)) {
            return false;
        }
        boolean allQueryUseSQLFederation = this.sqlFederationRule.getConfiguration().isAllQueryUseSQLFederation();
        if (allQueryUseSQLFederation) {
            return true;
        }
        SelectStatementContext selectStatementContext = (SelectStatementContext)sqlStatementContext;
        Collection databaseNames = selectStatementContext.getTablesContext().getDatabaseNames();
        if (databaseNames.size() > 1) {
            return true;
        }
        ShardingSphereDatabase usedDatabase = queryContext.getUsedDatabase();
        HashSet includedDataNodes = new HashSet();
        for (Map.Entry<ShardingSphereRule, SQLFederationDecider> entry : this.deciders.entrySet()) {
            boolean isUseSQLFederation = entry.getValue().decide(selectStatementContext, queryContext.getParameters(), globalRuleMetaData, usedDatabase, entry.getKey(), includedDataNodes);
            if (!isUseSQLFederation) continue;
            return true;
        }
        return false;
    }

    private boolean isQuerySystemSchema(QueryContext queryContext) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        if (!(sqlStatementContext instanceof SelectStatementContext)) {
            return false;
        }
        SelectStatementContext selectStatementContext = (SelectStatementContext)sqlStatementContext;
        ShardingSphereDatabase database = queryContext.getUsedDatabase();
        return SystemSchemaUtils.containsSystemSchema((DatabaseType)sqlStatementContext.getDatabaseType(), (Collection)selectStatementContext.getTablesContext().getSchemaNames(), (ShardingSphereDatabase)database) || SystemSchemaUtils.isOpenGaussSystemCatalogQuery((DatabaseType)sqlStatementContext.getDatabaseType(), (Collection)selectStatementContext.getSqlStatement().getProjections().getProjections());
    }

    public ResultSet executeQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, SQLFederationContext federationContext) {
        try {
            SelectStatementContext selectStatementContext = (SelectStatementContext)federationContext.getQueryContext().getSqlStatementContext();
            String databaseName = selectStatementContext.getTablesContext().getDatabaseNames().stream().findFirst().orElse(this.currentDatabaseName);
            String schemaName = selectStatementContext.getTablesContext().getSchemaName().orElse(this.currentSchemaName);
            OptimizerMetaData optimizerMetaData = this.sqlFederationRule.getOptimizerContext().getMetaData(databaseName);
            CalciteConnectionConfigImpl connectionConfig = new CalciteConnectionConfigImpl(this.sqlFederationRule.getOptimizerContext().getParserContext(databaseName).getDialectProps());
            CalciteCatalogReader catalogReader = SQLFederationPlannerUtils.createCatalogReader((String)schemaName, (Schema)optimizerMetaData.getSchema(schemaName), (RelDataTypeFactory)DEFAULT_DATA_TYPE_FACTORY, (CalciteConnectionConfig)connectionConfig, (DatabaseType)selectStatementContext.getDatabaseType());
            SqlValidator validator = SQLFederationPlannerUtils.createSqlValidator((CalciteCatalogReader)catalogReader, (RelDataTypeFactory)DEFAULT_DATA_TYPE_FACTORY, (DatabaseType)this.sqlFederationRule.getOptimizerContext().getParserContext(databaseName).getDatabaseType(), (CalciteConnectionConfig)connectionConfig);
            SqlToRelConverter converter = SQLFederationPlannerUtils.createSqlToRelConverter((CalciteCatalogReader)catalogReader, (SqlValidator)validator, (RelOptCluster)SQLFederationPlannerUtils.createRelOptCluster((RelDataTypeFactory)DEFAULT_DATA_TYPE_FACTORY), (SQLParserRule)this.sqlFederationRule.getOptimizerContext().getSqlParserRule(), (DatabaseType)this.sqlFederationRule.getOptimizerContext().getParserContext(databaseName).getDatabaseType(), (boolean)true);
            SchemaPlus sqlFederationSchema = catalogReader.getRootSchema().plus().getSubSchema(schemaName);
            ShardingSpherePreconditions.checkNotNull((Object)sqlFederationSchema, () -> new SQLFederationSchemaNotFoundException(federationContext.getQueryContext().getSql()));
            SQLFederationExecutionPlan executionPlan = this.compileQuery(prepareEngine, callback, federationContext, databaseName, schemaName, (Schema)sqlFederationSchema, converter);
            this.resultSet = this.executePlan(federationContext, executionPlan, validator, converter, (Schema)sqlFederationSchema);
            return this.resultSet;
        }
        catch (Exception ex) {
            throw new SQLFederationUnsupportedSQLException(federationContext.getQueryContext().getSql(), ex);
        }
    }

    private SQLFederationExecutionPlan compileQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, SQLFederationContext federationContext, String databaseName, String schemaName, Schema sqlFederationSchema, SqlToRelConverter converter) {
        SQLStatementContext sqlStatementContext = federationContext.getQueryContext().getSqlStatementContext();
        ShardingSpherePreconditions.checkState((boolean)(sqlStatementContext instanceof SelectStatementContext), () -> new IllegalArgumentException("SQL statement context must be select statement context."));
        this.registerTableScanExecutor(sqlFederationSchema, prepareEngine, callback, federationContext, this.sqlFederationRule.getOptimizerContext(), databaseName, schemaName);
        SQLStatementCompiler sqlStatementCompiler = new SQLStatementCompiler(converter);
        SQLFederationCompilerEngine compilerEngine = new SQLFederationCompilerEngine(databaseName, schemaName, this.sqlFederationRule.getConfiguration().getExecutionPlanCache());
        return compilerEngine.compile(this.buildCacheKey(federationContext, (SelectStatementContext)sqlStatementContext, sqlStatementCompiler, databaseName, schemaName), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executePlan(SQLFederationContext federationContext, SQLFederationExecutionPlan executionPlan, SqlValidator validator, SqlToRelConverter converter, Schema sqlFederationSchema) {
        try {
            Bindable executablePlan = EnumerableInterpretable.toBindable(Collections.emptyMap(), null, (EnumerableRel)((EnumerableRel)executionPlan.getPhysicalPlan()), (EnumerableRel.Prefer)EnumerableRel.Prefer.ARRAY);
            Map<String, Object> params = this.createParameters(federationContext.getQueryContext().getParameters());
            Enumerator enumerator = executablePlan.bind((DataContext)new SQLFederationBindContext(validator, converter, params)).enumerator();
            SQLFederationResultSet sQLFederationResultSet = new SQLFederationResultSet((Enumerator<Object>)enumerator, sqlFederationSchema, (SelectStatementContext)federationContext.getQueryContext().getSqlStatementContext(), executionPlan.getResultColumnType());
            return sQLFederationResultSet;
        }
        finally {
            this.processEngine.completeSQLExecution(federationContext.getProcessId());
        }
    }

    private ExecutionPlanCacheKey buildCacheKey(SQLFederationContext federationContext, SelectStatementContext selectStatementContext, SQLStatementCompiler sqlStatementCompiler, String databaseName, String schemaName) {
        ShardingSphereSchema schema = federationContext.getMetaData().getDatabase(databaseName).getSchema(schemaName);
        ExecutionPlanCacheKey result = new ExecutionPlanCacheKey(federationContext.getQueryContext().getSql(), (SQLStatement)selectStatementContext.getSqlStatement(), selectStatementContext.getDatabaseType().getType(), sqlStatementCompiler);
        for (String each : selectStatementContext.getTablesContext().getTableNames()) {
            ShardingSphereTable table = schema.getTable(each);
            ShardingSpherePreconditions.checkNotNull((Object)table, () -> new NoSuchTableException(each));
            result.getTableMetaDataVersions().put(table.getName(), 0);
        }
        return result;
    }

    private void registerTableScanExecutor(Schema sqlFederationSchema, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, SQLFederationContext federationContext, OptimizerContext optimizerContext, String databaseName, String schemaName) {
        if (null == sqlFederationSchema) {
            return;
        }
        SQLFederationExecutorContext executorContext = new SQLFederationExecutorContext(databaseName, schemaName, this.metaData.getProps());
        EnumerableScanExecutor scanExecutor = new EnumerableScanExecutor(prepareEngine, this.jdbcExecutor, callback, optimizerContext, executorContext, federationContext, this.metaData.getGlobalRuleMetaData(), this.statistics);
        for (ShardingSphereTable each : this.metaData.getDatabase(databaseName).getSchema(schemaName).getTables().values()) {
            Table table = sqlFederationSchema.getTable(each.getName());
            if (!(table instanceof SQLFederationTable)) continue;
            ((SQLFederationTable)table).setScanExecutor((ScanExecutor)scanExecutor);
        }
    }

    private Map<String, Object> createParameters(List<Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(params.size(), 1.0f);
        int index = 0;
        for (Object each : params) {
            result.put("?" + index++, each);
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
        if (null != this.resultSet) {
            this.resultSet.close();
        }
    }

    @Generated
    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    @Generated
    public Map<ShardingSphereRule, SQLFederationDecider> getDeciders() {
        return this.deciders;
    }

    @Generated
    public String getCurrentDatabaseName() {
        return this.currentDatabaseName;
    }

    @Generated
    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    @Generated
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public ShardingSphereStatistics getStatistics() {
        return this.statistics;
    }

    @Generated
    public JDBCExecutor getJdbcExecutor() {
        return this.jdbcExecutor;
    }

    @Generated
    public SQLFederationRule getSqlFederationRule() {
        return this.sqlFederationRule;
    }

    @Generated
    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

