/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.statement.ral.updatable.ImportMetaDataStatement;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.exception.generic.FileIOException;
import org.apache.shardingsphere.infra.util.json.JsonUtils;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyServerConfiguration;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedClusterInfo;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedMetaData;
import org.apache.shardingsphere.proxy.backend.util.YamlDatabaseConfigurationImportExecutor;

public final class ImportMetaDataExecutor
implements DistSQLUpdateExecutor<ImportMetaDataStatement> {
    private final YamlRuleConfigurationSwapperEngine ruleConfigSwapperEngine = new YamlRuleConfigurationSwapperEngine();
    private final YamlDatabaseConfigurationImportExecutor databaseConfigImportExecutor = new YamlDatabaseConfigurationImportExecutor();

    public void executeUpdate(ImportMetaDataStatement sqlStatement, ContextManager contextManager) throws SQLException {
        String jsonMetaDataConfig;
        if (sqlStatement.getFilePath().isPresent()) {
            File file = new File((String)sqlStatement.getFilePath().get());
            try {
                jsonMetaDataConfig = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
            }
            catch (IOException ignore) {
                throw new FileIOException(file);
            }
        } else {
            jsonMetaDataConfig = new String(Base64.decodeBase64((String)sqlStatement.getMetaDataValue()));
        }
        ExportedClusterInfo exportedClusterInfo = (ExportedClusterInfo)JsonUtils.fromJsonString((String)jsonMetaDataConfig, ExportedClusterInfo.class);
        ExportedMetaData exportedMetaData = exportedClusterInfo.getMetaData();
        this.importServerConfiguration(contextManager, exportedMetaData);
        this.importDatabase(exportedMetaData);
    }

    private void importServerConfiguration(ContextManager contextManager, ExportedMetaData exportedMetaData) throws SQLException {
        YamlProxyServerConfiguration yamlServerConfig = (YamlProxyServerConfiguration)YamlEngine.unmarshal((String)(exportedMetaData.getRules() + System.lineSeparator() + exportedMetaData.getProps()), YamlProxyServerConfiguration.class);
        if (null == yamlServerConfig) {
            return;
        }
        Collection rules = this.ruleConfigSwapperEngine.swapToRuleConfigurations(yamlServerConfig.getRules());
        for (RuleConfiguration each : rules) {
            contextManager.getPersistServiceFacade().getMetaDataManagerPersistService().alterGlobalRuleConfiguration(each);
        }
        contextManager.getPersistServiceFacade().getMetaDataManagerPersistService().alterProperties(yamlServerConfig.getProps());
    }

    private void importDatabase(ExportedMetaData exportedMetaData) throws SQLException {
        for (String each : exportedMetaData.getDatabases().values()) {
            YamlProxyDatabaseConfiguration yamlDatabaseConfig = (YamlProxyDatabaseConfiguration)YamlEngine.unmarshal((String)each, YamlProxyDatabaseConfiguration.class);
            this.databaseConfigImportExecutor.importDatabaseConfiguration(yamlDatabaseConfig);
        }
    }

    public Class<ImportMetaDataStatement> getType() {
        return ImportMetaDataStatement.class;
    }
}

