/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.schedule.core.job.statistics.collect;

import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.ScheduleJobBootstrap;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperConfiguration;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.metadata.persist.node.ShardingSphereDataNode;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.schedule.core.job.statistics.collect.StatisticsCollectJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatisticsCollectJobWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsCollectJobWorker.class);
    private static final String JOB_NAME = "statistics-collect";
    private static final String CRON_EXPRESSION = "*/30 * * * * ?";
    private static final AtomicBoolean WORKER_INITIALIZED = new AtomicBoolean(false);
    private static ScheduleJobBootstrap scheduleJobBootstrap;
    private final ContextManager contextManager;

    public void initialize() {
        if (!WORKER_INITIALIZED.compareAndSet(false, true)) {
            return;
        }
        ModeConfiguration modeConfig = this.contextManager.getComputeNodeInstanceContext().getModeConfiguration();
        if (!"ZooKeeper".equals(modeConfig.getRepository().getType())) {
            log.warn("Can not collect statistics because of unsupported cluster type: {}", (Object)modeConfig.getRepository().getType());
            return;
        }
        scheduleJobBootstrap = new ScheduleJobBootstrap(this.createRegistryCenter(modeConfig), (ElasticJob)new StatisticsCollectJob(this.contextManager), this.createJobConfiguration());
        scheduleJobBootstrap.schedule();
    }

    private CoordinatorRegistryCenter createRegistryCenter(ModeConfiguration modeConfig) {
        ClusterPersistRepositoryConfiguration repositoryConfig = (ClusterPersistRepositoryConfiguration)modeConfig.getRepository();
        String namespace = String.join((CharSequence)"/", repositoryConfig.getNamespace(), ShardingSphereDataNode.getJobPath());
        ZookeeperRegistryCenter result = new ZookeeperRegistryCenter(this.getZookeeperConfiguration(repositoryConfig, namespace));
        result.init();
        return result;
    }

    private ZookeeperConfiguration getZookeeperConfiguration(ClusterPersistRepositoryConfiguration repositoryConfig, String namespace) {
        int operationTimeoutMilliseconds;
        int timeToLiveSeconds;
        ZookeeperConfiguration result = new ZookeeperConfiguration(repositoryConfig.getServerLists(), namespace);
        Properties props = repositoryConfig.getProps();
        int retryIntervalMilliseconds = props.containsKey("retryIntervalMilliseconds") ? (Integer)props.get("retryIntervalMilliseconds") : 500;
        int maxRetries = props.containsKey("maxRetries") ? (Integer)props.get("maxRetries") : 3;
        result.setBaseSleepTimeMilliseconds(retryIntervalMilliseconds);
        result.setMaxRetries(maxRetries);
        result.setMaxSleepTimeMilliseconds(retryIntervalMilliseconds * maxRetries);
        int n = timeToLiveSeconds = props.containsKey("timeToLiveSeconds") ? (Integer)props.get("timeToLiveSeconds") : 60;
        if (0 != timeToLiveSeconds) {
            result.setSessionTimeoutMilliseconds(timeToLiveSeconds * 1000);
        }
        int n2 = operationTimeoutMilliseconds = props.containsKey("operationTimeoutMilliseconds") ? (Integer)props.get("operationTimeoutMilliseconds") : 500;
        if (0 != operationTimeoutMilliseconds) {
            result.setConnectionTimeoutMilliseconds(operationTimeoutMilliseconds);
        }
        result.setDigest(props.getProperty("digest"));
        return result;
    }

    private JobConfiguration createJobConfiguration() {
        return JobConfiguration.newBuilder((String)JOB_NAME, (int)1).cron(CRON_EXPRESSION).overwrite(true).build();
    }

    public void destroy() {
        if (WORKER_INITIALIZED.compareAndSet(true, false)) {
            Optional.ofNullable(scheduleJobBootstrap).ifPresent(ScheduleJobBootstrap::shutdown);
            scheduleJobBootstrap = null;
        }
    }

    @Generated
    public StatisticsCollectJobWorker(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

