/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.global;

import java.sql.SQLException;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.global.GlobalRuleDefinitionExecutor;
import org.apache.shardingsphere.distsql.statement.rdl.rule.global.GlobalRuleDefinitionStatement;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class GlobalRuleDefinitionExecuteEngine {
    private final GlobalRuleDefinitionStatement sqlStatement;
    private final ContextManager contextManager;
    private final GlobalRuleDefinitionExecutor executor;

    public void executeUpdate() throws SQLException {
        ShardingSphereRule rule = this.contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(this.executor.getRuleClass());
        this.executor.setRule(rule);
        this.executor.checkBeforeUpdate(this.sqlStatement);
        this.contextManager.getPersistServiceFacade().getMetaDataManagerPersistService().alterGlobalRuleConfiguration(this.processUpdate(this.sqlStatement, rule));
    }

    private RuleConfiguration processUpdate(GlobalRuleDefinitionStatement sqlStatement, ShardingSphereRule rule) {
        RuleConfiguration result = this.executor.buildToBeAlteredRuleConfiguration(sqlStatement);
        Collection ruleConfigs = this.contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getConfigurations();
        ruleConfigs.remove(rule.getConfiguration());
        ruleConfigs.add(result);
        return result;
    }

    @Generated
    public GlobalRuleDefinitionExecuteEngine(GlobalRuleDefinitionStatement sqlStatement, ContextManager contextManager, GlobalRuleDefinitionExecutor executor) {
        this.sqlStatement = sqlStatement;
        this.contextManager = contextManager;
        this.executor = executor;
    }
}

