/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.decorator.RuleConfigurationDecorator;
import org.apache.shardingsphere.infra.datasource.pool.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.GenericSchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.metadata.persist.data.ShardingSphereDataPersistService;
import org.apache.shardingsphere.metadata.persist.service.config.database.DataSourceNodePersistService;
import org.apache.shardingsphere.metadata.persist.service.config.database.DataSourceUnitPersistService;
import org.apache.shardingsphere.metadata.persist.service.config.database.DatabaseRulePersistService;
import org.apache.shardingsphere.metadata.persist.service.config.global.GlobalRulePersistService;
import org.apache.shardingsphere.metadata.persist.service.config.global.PropertiesPersistService;
import org.apache.shardingsphere.metadata.persist.service.metadata.DatabaseMetaDataPersistFacade;
import org.apache.shardingsphere.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class MetaDataPersistService {
    private final PersistRepository repository;
    private final MetaDataVersionPersistService metaDataVersionPersistService;
    private final DataSourceUnitPersistService dataSourceUnitService;
    private final DataSourceNodePersistService dataSourceNodeService;
    private final DatabaseMetaDataPersistFacade databaseMetaDataFacade;
    private final DatabaseRulePersistService databaseRulePersistService;
    private final GlobalRulePersistService globalRuleService;
    private final PropertiesPersistService propsService;
    private final ShardingSphereDataPersistService shardingSphereDataPersistService;

    public MetaDataPersistService(PersistRepository repository) {
        this.repository = repository;
        this.metaDataVersionPersistService = new MetaDataVersionPersistService(repository);
        this.dataSourceUnitService = new DataSourceUnitPersistService(repository);
        this.dataSourceNodeService = new DataSourceNodePersistService(repository);
        this.databaseMetaDataFacade = new DatabaseMetaDataPersistFacade(repository, this.metaDataVersionPersistService);
        this.databaseRulePersistService = new DatabaseRulePersistService(repository);
        this.globalRuleService = new GlobalRulePersistService(repository, this.metaDataVersionPersistService);
        this.propsService = new PropertiesPersistService(repository, this.metaDataVersionPersistService);
        this.shardingSphereDataPersistService = new ShardingSphereDataPersistService(repository);
    }

    public void persistGlobalRuleConfiguration(Collection<RuleConfiguration> globalRuleConfigs, Properties props) {
        this.globalRuleService.persist(globalRuleConfigs);
        this.propsService.persist(props);
    }

    public void persistConfigurations(String databaseName, DatabaseConfiguration databaseConfig, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> rules) {
        Map<String, DataSourcePoolProperties> propsMap = this.getDataSourcePoolPropertiesMap(databaseConfig);
        if (propsMap.isEmpty() && databaseConfig.getRuleConfigurations().isEmpty()) {
            this.databaseMetaDataFacade.getDatabase().add(databaseName);
        } else {
            this.dataSourceUnitService.persist(databaseName, propsMap);
            this.databaseRulePersistService.persist(databaseName, this.decorateRuleConfigs(databaseName, dataSources, rules));
        }
    }

    private Collection<RuleConfiguration> decorateRuleConfigs(String databaseName, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> rules) {
        LinkedList<RuleConfiguration> result = new LinkedList<RuleConfiguration>();
        for (ShardingSphereRule each : rules) {
            RuleConfiguration ruleConfig = each.getConfiguration();
            Optional decorator = TypedSPILoader.findService(RuleConfigurationDecorator.class, ruleConfig.getClass());
            result.add(decorator.map(optional -> optional.decorate(databaseName, dataSources, rules, ruleConfig)).orElse(ruleConfig));
        }
        return result;
    }

    private Map<String, DataSourcePoolProperties> getDataSourcePoolPropertiesMap(DatabaseConfiguration databaseConfig) {
        return databaseConfig.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSourcePoolProperties(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public Map<String, DataSourceConfiguration> loadDataSourceConfigurations(String databaseName) {
        return this.dataSourceUnitService.load(databaseName).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePoolPropertiesCreator.createConfiguration((DataSourcePoolProperties)((DataSourcePoolProperties)entry.getValue())), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public void persistReloadDatabaseByAlter(String databaseName, ShardingSphereDatabase reloadDatabase, ShardingSphereDatabase currentDatabase) {
        Map toBeDeletedSchemas = GenericSchemaManager.getToBeDroppedTablesBySchemas((Map)reloadDatabase.getSchemas(), (Map)currentDatabase.getSchemas());
        Map toBeAddedSchemas = GenericSchemaManager.getToBeAddedTablesBySchemas((Map)reloadDatabase.getSchemas(), (Map)currentDatabase.getSchemas());
        toBeAddedSchemas.forEach((key, value) -> this.databaseMetaDataFacade.getSchema().alterByRuleAltered(databaseName, (ShardingSphereSchema)value));
        toBeDeletedSchemas.forEach((key, value) -> this.databaseMetaDataFacade.getTable().drop(databaseName, (String)key, value.getTables()));
    }

    public void persistReloadDatabaseByDrop(String databaseName, ShardingSphereDatabase reloadDatabase, ShardingSphereDatabase currentDatabase) {
        Map toBeAlterSchemas = GenericSchemaManager.getToBeDroppedTablesBySchemas((Map)reloadDatabase.getSchemas(), (Map)currentDatabase.getSchemas());
        Map toBeAddedSchemas = GenericSchemaManager.getToBeAddedTablesBySchemas((Map)reloadDatabase.getSchemas(), (Map)currentDatabase.getSchemas());
        toBeAddedSchemas.forEach((key, value) -> this.databaseMetaDataFacade.getSchema().alterByRuleDropped(databaseName, (String)key, (ShardingSphereSchema)value));
        toBeAlterSchemas.forEach((key, value) -> this.databaseMetaDataFacade.getTable().drop(databaseName, (String)key, value.getTables()));
    }

    @Generated
    public PersistRepository getRepository() {
        return this.repository;
    }

    @Generated
    public MetaDataVersionPersistService getMetaDataVersionPersistService() {
        return this.metaDataVersionPersistService;
    }

    @Generated
    public DataSourceUnitPersistService getDataSourceUnitService() {
        return this.dataSourceUnitService;
    }

    @Generated
    public DataSourceNodePersistService getDataSourceNodeService() {
        return this.dataSourceNodeService;
    }

    @Generated
    public DatabaseMetaDataPersistFacade getDatabaseMetaDataFacade() {
        return this.databaseMetaDataFacade;
    }

    @Generated
    public DatabaseRulePersistService getDatabaseRulePersistService() {
        return this.databaseRulePersistService;
    }

    @Generated
    public GlobalRulePersistService getGlobalRuleService() {
        return this.globalRuleService;
    }

    @Generated
    public PropertiesPersistService getPropsService() {
        return this.propsService;
    }

    @Generated
    public ShardingSphereDataPersistService getShardingSphereDataPersistService() {
        return this.shardingSphereDataPersistService;
    }
}

