/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.parameter.builder.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;

public final class GroupedParameterBuilder
implements ParameterBuilder {
    private final List<StandardParameterBuilder> parameterBuilders;
    private final StandardParameterBuilder genericParameterBuilder;
    private String derivedColumnName;

    public GroupedParameterBuilder(List<List<Object>> groupedParams, List<Object> genericParams) {
        this.parameterBuilders = new ArrayList<StandardParameterBuilder>(groupedParams.size());
        for (List<Object> each : groupedParams) {
            this.parameterBuilders.add(new StandardParameterBuilder(each));
        }
        this.genericParameterBuilder = new StandardParameterBuilder(genericParams);
    }

    @Override
    public List<Object> getParameters() {
        LinkedList<Object> result = new LinkedList<Object>();
        for (int i = 0; i < this.parameterBuilders.size(); ++i) {
            result.addAll(this.getParameters(i));
        }
        result.addAll(this.genericParameterBuilder.getParameters());
        return result;
    }

    public List<Object> getParameters(int count) {
        return this.parameterBuilders.get(count).getParameters();
    }

    public Optional<String> getDerivedColumnName() {
        return Optional.ofNullable(this.derivedColumnName);
    }

    @Generated
    public List<StandardParameterBuilder> getParameterBuilders() {
        return this.parameterBuilders;
    }

    @Generated
    public StandardParameterBuilder getGenericParameterBuilder() {
        return this.genericParameterBuilder;
    }

    @Generated
    public void setDerivedColumnName(String derivedColumnName) {
        this.derivedColumnName = derivedColumnName;
    }
}

