/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cache.route;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sharding.cache.ShardingCache;
import org.apache.shardingsphere.sharding.cache.checker.ShardingRouteCacheableCheckResult;
import org.apache.shardingsphere.sharding.cache.route.cache.ShardingRouteCacheKey;
import org.apache.shardingsphere.sharding.cache.route.cache.ShardingRouteCacheValue;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class CachedShardingSQLRouter {
    public Optional<RouteContext> loadRouteContext(OriginSQLRouter originSQLRouter, QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, ShardingCache shardingCache, ConfigurationProperties props) {
        if (queryContext.getSql().length() > shardingCache.getConfiguration().getAllowedMaxSqlLength()) {
            return Optional.empty();
        }
        ShardingRouteCacheableCheckResult cacheableCheckResult = shardingCache.getRouteCacheableChecker().check(database, queryContext);
        if (!cacheableCheckResult.isProbablyCacheable()) {
            return Optional.empty();
        }
        ArrayList<Object> shardingConditionParams = new ArrayList<Object>(cacheableCheckResult.getShardingConditionParameterMarkerIndexes().size());
        for (int each : cacheableCheckResult.getShardingConditionParameterMarkerIndexes()) {
            if (each >= queryContext.getParameters().size()) {
                return Optional.empty();
            }
            shardingConditionParams.add(queryContext.getParameters().get(each));
        }
        Optional cachedResult = shardingCache.getRouteCache().get(new ShardingRouteCacheKey(queryContext.getSql(), shardingConditionParams)).flatMap(ShardingRouteCacheValue::getCachedRouteContext);
        RouteContext result = cachedResult.orElseGet(() -> originSQLRouter.createRouteContext(queryContext, globalRuleMetaData, database, shardingCache.getShardingRule(), props));
        if (!cachedResult.isPresent() && this.hitOneShardOnly(result)) {
            shardingCache.getRouteCache().put(new ShardingRouteCacheKey(queryContext.getSql(), shardingConditionParams), new ShardingRouteCacheValue(result));
        }
        return Optional.of(result);
    }

    private boolean hitOneShardOnly(RouteContext routeContext) {
        return 1 == routeContext.getRouteUnits().size() && 1 == ((RouteUnit)routeContext.getRouteUnits().iterator().next()).getTableMappers().size() && 1 == routeContext.getOriginalDataNodes().size() && 1 == ((Collection)routeContext.getOriginalDataNodes().iterator().next()).size();
    }

    @FunctionalInterface
    public static interface OriginSQLRouter {
        public RouteContext createRouteContext(QueryContext var1, RuleMetaData var2, ShardingSphereDatabase var3, ShardingRule var4, ConfigurationProperties var5);
    }
}

