/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dal.show;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.sharding.merge.dal.show.LogicTablesMergedResult;
import org.apache.shardingsphere.sharding.rule.BindingTableRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShowCreateTableMergedResult
extends LogicTablesMergedResult {
    public ShowCreateTableMergedResult(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, ShardingSphereSchema schema, List<QueryResult> queryResults) throws SQLException {
        super(shardingRule, sqlStatementContext, schema, queryResults);
    }

    @Override
    protected void setCellValue(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName, ShardingSphereTable table, ShardingRule shardingRule) {
        String actualIndexName;
        memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replaceFirst(actualTableName, logicTableName));
        this.setViewCellValue(memoryResultSetRow, logicTableName, actualTableName, shardingRule);
        for (ShardingSphereIndex each : table.getIndexValues()) {
            actualIndexName = IndexMetaDataUtils.getActualIndexName((String)each.getName(), (String)actualTableName);
            memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replace(actualIndexName, each.getName()));
        }
        for (ShardingSphereIndex each : table.getConstraintValues()) {
            actualIndexName = IndexMetaDataUtils.getActualIndexName((String)each.getName(), (String)actualTableName);
            memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replace(actualIndexName, each.getName()));
            Optional<ShardingTable> shardingTable = shardingRule.findShardingTable(each.getReferencedTableName());
            if (!shardingTable.isPresent()) continue;
            for (DataNode dataNode : shardingTable.get().getActualDataNodes()) {
                memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replace(dataNode.getTableName(), each.getReferencedTableName()));
            }
        }
    }

    private void setViewCellValue(MemoryQueryResultRow memoryResultSetRow, String logicTableName, String actualTableName, ShardingRule shardingRule) {
        Optional<ShardingTable> shardingTable = shardingRule.findShardingTable(logicTableName);
        Optional<BindingTableRule> bindingTableRule = shardingRule.findBindingTableRule(logicTableName);
        if (shardingTable.isPresent() && bindingTableRule.isPresent()) {
            Collection actualDataNodes = shardingTable.get().getActualDataNodes().stream().filter(each -> each.getTableName().equalsIgnoreCase(actualTableName)).collect(Collectors.toList());
            CaseInsensitiveMap logicAndActualTablesFromBindingTables = new CaseInsensitiveMap();
            for (DataNode dataNode : actualDataNodes) {
                logicAndActualTablesFromBindingTables.putAll(shardingRule.getLogicAndActualTablesFromBindingTable(dataNode.getDataSourceName(), logicTableName, actualTableName, bindingTableRule.get().getAllLogicTables()));
            }
            for (Map.Entry entry : logicAndActualTablesFromBindingTables.entrySet()) {
                memoryResultSetRow.setCell(2, (Object)memoryResultSetRow.getCell(2).toString().replaceFirst((String)entry.getValue(), (String)entry.getKey()));
            }
        }
    }
}

