/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.metadata.data;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereStatisticsCollector;
import org.apache.shardingsphere.sharding.metadata.data.dialect.DialectShardingStatisticsTableCollector;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShardingStatisticsTableCollector
implements ShardingSphereStatisticsCollector {
    private static final String SHARDING_TABLE_STATISTICS = "sharding_table_statistics";

    public Optional<ShardingSphereTableData> collect(String databaseName, ShardingSphereTable table, Map<String, ShardingSphereDatabase> databases, RuleMetaData globalRuleMetaData) throws SQLException {
        ShardingSphereTableData result = new ShardingSphereTableData(SHARDING_TABLE_STATISTICS);
        DatabaseType protocolType = databases.values().iterator().next().getProtocolType();
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(protocolType).getDialectDatabaseMetaData();
        if (dialectDatabaseMetaData.getDefaultSchema().isPresent()) {
            this.collectFromDatabase(databases.get(databaseName), result);
        } else {
            for (ShardingSphereDatabase each : databases.values()) {
                this.collectFromDatabase(each, result);
            }
        }
        return result.getRows().isEmpty() ? Optional.empty() : Optional.of(result);
    }

    private void collectFromDatabase(ShardingSphereDatabase database, ShardingSphereTableData tableData) throws SQLException {
        Optional shardingRule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        if (!shardingRule.isPresent()) {
            return;
        }
        this.collectForShardingStatisticTable(database, (ShardingRule)shardingRule.get(), tableData);
    }

    private void collectForShardingStatisticTable(ShardingSphereDatabase database, ShardingRule shardingRule, ShardingSphereTableData tableData) throws SQLException {
        int count = 1;
        for (ShardingTable each : shardingRule.getShardingTables().values()) {
            for (DataNode dataNode : each.getActualDataNodes()) {
                LinkedList<Object> row = new LinkedList<Object>();
                row.add(count++);
                row.add(database.getName());
                row.add(each.getLogicTable());
                row.add(dataNode.getDataSourceName());
                row.add(dataNode.getTableName());
                this.addTableRowsAndDataLength(database.getResourceMetaData().getStorageUnits(), dataNode, row);
                tableData.getRows().add(new ShardingSphereRowData(row));
            }
        }
    }

    private void addTableRowsAndDataLength(Map<String, StorageUnit> storageUnits, DataNode dataNode, List<Object> row) throws SQLException {
        DatabaseType databaseType = storageUnits.get(dataNode.getDataSourceName()).getStorageType();
        Optional dialectCollector = DatabaseTypedSPILoader.findService(DialectShardingStatisticsTableCollector.class, (DatabaseType)databaseType);
        boolean isAppended = false;
        if (dialectCollector.isPresent()) {
            try (Connection connection = storageUnits.get(dataNode.getDataSourceName()).getDataSource().getConnection();){
                isAppended = ((DialectShardingStatisticsTableCollector)dialectCollector.get()).appendRow(connection, dataNode, row);
            }
        }
        if (!isAppended) {
            row.add(BigDecimal.ZERO);
            row.add(BigDecimal.ZERO);
        }
    }

    public String getType() {
        return SHARDING_TABLE_STATISTICS;
    }
}

